/*
 * Decompiled with CFR 0.152.
 */
package io.transwarp.image;

import com.alibaba.fastjson.JSONObject;
import io.transwarp.Client;
import io.transwarp.jar.JarFileUtil;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class ImageTool {
    private static Logger logger = Logger.getLogger(ImageTool.class);
    public static final String inceptorLibPath = "/usr/lib/inceptor/lib";
    public static final String inceptorJarPath = "/usr/lib/inceptor";
    public static final String imageVersionFile = "/usr/lib/inceptor/version.json";
    public static final String sha256FilePath = "/usr/lib/inceptor/md5.txt";

    private String getImageVersion() {
        String version = null;
        File file = new File(imageVersionFile);
        if (file.exists()) {
            try {
                JSONObject jsonObject = JarFileUtil.readJsonFile(imageVersionFile);
                version = jsonObject.get("imageVersion").toString();
                logger.info(String.format("image \u7684\u7248\u672c\u4e3a%s", version));
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        } else {
            logger.warn("this image has no version file!!");
        }
        return version;
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        ImageTool imageTool = new ImageTool();
        try {
            HashMap<String, String> commitMap1;
            HashMap<String, String> commitMap;
            CommandLine cl = parser.parse(Client.opts, args);
            String outputPath = "output";
            if (cl.hasOption('h')) {
                Client.printHelp(Client.opts);
            }
            if (cl.hasOption('o')) {
                outputPath = cl.getOptionValue('o');
            }
            if (cl.hasOption("checkJar")) {
                String[] checkJars = cl.getOptionValues("checkJar");
                if (checkJars.length == 2) {
                    JarFileUtil.checkJar(checkJars[0], checkJars[1]);
                } else {
                    logger.error("wrong params");
                    Client.printHelp(Client.opts);
                }
            }
            if (cl.hasOption("getCommitId")) {
                commitMap = JarFileUtil.getJarCommitId(JarFileUtil.getJarsFile(inceptorLibPath));
                commitMap1 = JarFileUtil.getJarCommitId(JarFileUtil.getJarsFile(inceptorJarPath));
                commitMap.putAll(commitMap1);
                JarFileUtil.generateFile(outputPath, commitMap);
            }
            if (cl.hasOption("getCommitIdWithTitle")) {
                commitMap = JarFileUtil.getJarCommitIdWithTitle(JarFileUtil.getJarsFile(inceptorLibPath));
                commitMap1 = JarFileUtil.getJarCommitIdWithTitle(JarFileUtil.getJarsFile(inceptorJarPath));
                commitMap.putAll(commitMap1);
                JarFileUtil.generateFile(outputPath, commitMap);
            }
            if (cl.hasOption("getImageVersion")) {
                imageTool.getImageVersion();
            }
        }
        catch (ParseException e) {
            logger.error(e.toString());
        }
    }
}

