/*
 * Decompiled with CFR 0.152.
 */
package io.transwarp.jar;

import com.alibaba.fastjson.JSONObject;
import io.transwarp.jar.JarWhiteList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileUtil {
    private static Logger logger = Logger.getLogger(JarFileUtil.class);

    public static ArrayList<String> getJarsFile(String dirName) {
        File[] files;
        ArrayList<String> jarFiles = new ArrayList<String>();
        File file = new File(dirName);
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                if (f.isFile() && f.getName().endsWith(".jar") && JarFileUtil.checkWhiteList(f.getName()).booleanValue()) {
                    jarFiles.add(f.getAbsolutePath());
                }
                if (!f.isDirectory()) continue;
                jarFiles.addAll(JarFileUtil.getJarsFile(f.getAbsolutePath()));
            }
        }
        return jarFiles;
    }

    private static Boolean checkWhiteList(String jarName) {
        ResourceBundle localResourceBundle = ResourceBundle.getBundle(JarWhiteList.INCEPTOR_WHITELIST.getName());
        String whiteLists = localResourceBundle.getString(JarWhiteList.INCEPTOR_JAR.getName());
        if (whiteLists.length() > 0 && whiteLists.trim().length() > 0) {
            String[] whiteList;
            for (String s : whiteList = whiteLists.split(";")) {
                if (!jarName.matches(s)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static HashMap<String, String> getJarCommitId(List<String> jars) {
        HashMap<String, String> jarMap = new HashMap<String, String>();
        for (String jar : jars) {
            try {
                String commitID;
                JarFile file = new JarFile(jar);
                Manifest manifest = file.getManifest();
                if (manifest == null || manifest.getMainAttributes().isEmpty() || (commitID = file.getManifest().getMainAttributes().getValue("Build-Revision")) == null || commitID.length() <= 0) continue;
                System.out.print(".");
                jarMap.put(jar, commitID);
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
        }
        return jarMap;
    }

    public static HashMap<String, String> getJarCommitIdWithTitle(List<String> jars) {
        HashMap<String, String> jarMap = new HashMap<String, String>();
        for (String jar : jars) {
            try {
                JarFile file = new JarFile(jar);
                Manifest manifest = file.getManifest();
                if (manifest == null || manifest.getMainAttributes().isEmpty()) continue;
                String jarTitle = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                String commitID = manifest.getMainAttributes().getValue("Build-Revision");
                if (commitID == null || commitID.length() <= 0) continue;
                System.out.print(".");
                if (jarTitle != null) {
                    jarMap.put(jarTitle, commitID);
                    continue;
                }
                jarMap.put(jar, commitID);
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
        }
        return jarMap;
    }

    public static JSONObject readJsonFile(String path) {
        String content = null;
        try {
            File file = new File(path);
            content = FileUtils.readFileToString(file, Charset.defaultCharset());
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        return JSONObject.parseObject(content);
    }

    public static void generateFile(String destPath, Map<String, String> commitMap) {
        File destFile = new File(destPath);
        if (destFile.exists() && destFile.isFile()) {
            logger.error(String.format("this output path: %s is a file,not a directory", destPath));
        }
        if (!destFile.exists() && !destFile.mkdir()) {
            logger.error("\u65b0\u5efa\u8f93\u51fa\u76ee\u5f55\u5931\u8d25\uff01");
        }
        if (destFile.isDirectory() && !commitMap.isEmpty()) {
            try {
                String commitFile = destFile.getAbsolutePath() + File.separator + "commitId.txt";
                BufferedWriter fileWriter = new BufferedWriter(new FileWriter(commitFile));
                for (Map.Entry<String, String> entry : commitMap.entrySet()) {
                    fileWriter.write(String.format("%s:%s", entry.getKey(), entry.getValue()));
                    fileWriter.newLine();
                }
                System.out.print("\n");
                System.out.println(String.format("parsed total %s jar commitId", Integer.toString(commitMap.size())));
                fileWriter.close();
                logger.info(String.format("\u83b7\u53d6\u7684jar\u5305commitId \u6587\u4ef6\u4e3a %s", "commitId.txt"));
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
        }
    }

    public static HashMap<String, String> parseJarmd5File(String filePath) {
        HashMap<String, String> jarMd5Map = new HashMap<String, String>();
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            try {
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    String[] rows = line.split(" ");
                    if (rows.length == 3) {
                        jarMd5Map.put(rows[2], rows[0]);
                        continue;
                    }
                    if (rows.length == 2) {
                        jarMd5Map.put(rows[1], rows[0]);
                        continue;
                    }
                    logger.error(String.format("the md5 file :%s has incorrect format data!", filePath));
                }
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
        }
        return jarMd5Map;
    }

    public static void checkJar(String originalFile, String newFile) {
        File original = new File(originalFile);
        File newMd5 = new File(newFile);
        int count = 0;
        logger.info("=========\u5f00\u59cb\u79c1\u5305\u68c0\u6d4b=================");
        if (!original.exists()) {
            logger.warn(String.format("\u6587\u4ef6 %s \u4e0d\u5b58\u5728,\u505c\u6b62\u79c1\u5305\u68c0\u6d4b", originalFile));
            return;
        }
        if (!newMd5.exists()) {
            logger.warn(String.format("\u6587\u4ef6 %s \u4e0d\u5b58\u5728\uff0c\u505c\u6b62\u79c1\u5305\u68c0\u6d4b", newFile));
            return;
        }
        HashMap<String, String> originalJarMd5Map = JarFileUtil.parseJarmd5File(originalFile);
        HashMap<String, String> newJarMd5Map = JarFileUtil.parseJarmd5File(newFile);
        for (Map.Entry<String, String> entry : originalJarMd5Map.entrySet()) {
            String originalMd5 = entry.getValue();
            String jar = entry.getKey();
            if (newJarMd5Map.keySet().contains(jar) && !originalMd5.equals(newJarMd5Map.get(jar))) {
                logger.warn(String.format("\u8bf7\u6ce8\u610f%s \u4e0d\u662f\u539f\u59cbimage\u7684jar\u5305\uff0c\u88ab\u66ff\u6362\u8fc7\uff01\uff01\uff01", jar));
                ++count;
                continue;
            }
            System.out.print(".");
        }
        System.out.print("\n");
        logger.info(String.format("\n\u79c1\u5305\u68c0\u6d4b\u5b8c\u6210,\u5171\u6709 %s\u4e2a\u79c1\u5305", Integer.toString(count)));
    }
}

