/*
 * Decompiled with CFR 0.152.
 */
package io.transwarp.project;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ImageVersion {
    private static Logger logger = Logger.getLogger(ImageVersion.class);

    public static void increaseImageVersion(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            logger.error("please input valid param");
        } else {
            try {
                File file = new File(filePath);
                String content = FileUtils.readFileToString(file, Charset.defaultCharset());
                JSONObject jsonObject = JSONObject.parseObject(content);
                String versionString = jsonObject.getString("imageVersion");
                logger.info("image version is " + versionString);
                String[] versionsStrs = versionString.split("\\.");
                if (versionsStrs.length > 0) {
                    int version = Integer.parseInt(versionsStrs[versionsStrs.length - 1]);
                    logger.info(String.format("the last image version is %s", version));
                    String newVersion = versionString.substring(0, versionString.lastIndexOf(String.valueOf(version))) + ++version;
                    logger.info("new version is " + newVersion);
                    jsonObject.put("imageVersion", (Object)newVersion);
                    FileUtils.write(file, (CharSequence)jsonObject.toString(), "utf-8");
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public static void showUsage() {
        System.out.println("usage:");
        System.out.println("      java -cp imageTool/fast-release-1.0-SNAPSHOT.jar io.transwarp.project.ImageVersion <versionFilePath>");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ImageVersion.showUsage();
        } else {
            ImageVersion.increaseImageVersion(args[0]);
        }
    }
}

