/*
 * Decompiled with CFR 0.152.
 */
package io.transwarp.project;

import io.transwarp.project.InceptorProjects;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.TagsApi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag {
    public GitLabApi gitLabApi;
    private String gitlabServer = "http://172.16.1.41:10080";
    private final Logger logger = Logger.getLogger(Tag.class);

    public Tag(String token) {
        this.gitLabApi = new GitLabApi(this.gitlabServer, token);
    }

    public void tag(HashMap<String, String> commitsMap, String tagName) {
        Map<String, String> inceptorProjects = InceptorProjects.getInceptorProjects();
        HashSet<String> tagedMap = new HashSet<String>();
        TagsApi tagsApi = this.gitLabApi.getTagsApi();
        for (Map.Entry<String, String> entry : commitsMap.entrySet()) {
            if (!inceptorProjects.containsKey(entry.getKey())) continue;
            try {
                if (tagedMap.contains(inceptorProjects.get(entry.getKey()))) continue;
                this.logger.info(String.format("\u5f00\u59cb\u7ed9\u9879\u76ee\u6253tag %s,commit id\u4e3a%s, tag\u540d\u79f0\u4e3a\uff1a%s", inceptorProjects.get(entry.getKey()), entry.getValue(), tagName));
                tagsApi.createTag(inceptorProjects.get(entry.getKey()), tagName, entry.getValue());
                tagedMap.add(inceptorProjects.get(entry.getKey()));
            }
            catch (GitLabApiException e) {
                this.logger.error(e.toString());
            }
        }
    }
}

