/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.RegistryRepository;
import org.gitlab4j.api.models.RegistryRepositoryTag;

public class ContainerRegistryApi
extends AbstractApi {
    public ContainerRegistryApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<RegistryRepository> getRepositories(Object projectIdOrPath) throws GitLabApiException {
        return this.getRepositories(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<RegistryRepository> getRepositories(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "registry", "repositories");
        return response.readEntity(new GenericType<List<RegistryRepository>>(){});
    }

    public Pager<RegistryRepository> getRepositories(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<RegistryRepository>(this, RegistryRepository.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "registry", "repositories");
    }

    public Stream<RegistryRepository> getRepositoriesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getRepositories(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public void deleteRepository(Object projectIdOrPath, Integer repositoryId) throws GitLabApiException {
        if (repositoryId == null) {
            throw new RuntimeException("repositoryId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "registry", "repositories", repositoryId);
    }

    public List<RegistryRepositoryTag> getRepositoryTags(Object projectIdOrPath, Integer repositoryId) throws GitLabApiException {
        return this.getRepositoryTags(projectIdOrPath, repositoryId, this.getDefaultPerPage()).all();
    }

    public Pager<RegistryRepositoryTag> getRepositoryTags(Object projectIdOrPath, Integer repositoryId, int itemsPerPage) throws GitLabApiException {
        return new Pager<RegistryRepositoryTag>(this, RegistryRepositoryTag.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "registry", "repositories", repositoryId, "tags");
    }

    public Stream<RegistryRepositoryTag> getRepositoryTagsStream(Object projectIdOrPath, Integer repositoryId) throws GitLabApiException {
        return this.getRepositoryTags(projectIdOrPath, repositoryId, this.getDefaultPerPage()).stream();
    }

    public RegistryRepositoryTag getRepositoryTag(Object projectIdOrPath, Integer repositoryId, String tagName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "registry", "repositories", repositoryId, "tags", tagName);
        return response.readEntity(new GenericType<RegistryRepositoryTag>(){});
    }

    public Optional<RegistryRepositoryTag> getOptionalRepositoryTag(Object projectIdOrPath, Integer repositoryId, String tagName) {
        try {
            return Optional.ofNullable(this.getRepositoryTag(projectIdOrPath, repositoryId, tagName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public void deleteRepositoryTag(Object projectIdOrPath, Integer repositoryId, String tagName) throws GitLabApiException {
        if (repositoryId == null) {
            throw new RuntimeException("repositoryId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "registry", "repositories", repositoryId, "tags", tagName);
    }

    public void deleteRepositoryTags(Object projectIdOrPath, Integer repositoryId, String nameRegex, Integer keepN, String olderThan) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name_regex", nameRegex, true).withParam("keep_n", keepN).withParam("older_than", olderThan);
        this.delete(Response.Status.NO_CONTENT, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "registry", "repositories", repositoryId, "tags");
    }
}

