/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Discussion;
import org.gitlab4j.api.models.Note;
import org.gitlab4j.api.models.Position;

public class DiscussionsApi
extends AbstractApi {
    public DiscussionsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Discussion> getIssueDiscussions(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        Pager<Discussion> pager = this.getIssueDiscussionsPager(projectIdOrPath, issueIid, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getIssueDiscussions(Object projectIdOrPath, Integer issueIid, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getIssueDiscussions(projectIdOrPath, issueIid);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "discussions");
        return response.readEntity(new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getIssueDiscussionsPager(Object projectIdOrPath, Integer issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "discussions");
    }

    public Stream<Discussion> getIssueDiscussionsStream(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        Pager<Discussion> pager = this.getIssueDiscussionsPager(projectIdOrPath, issueIid, this.getDefaultPerPage());
        return pager.stream();
    }

    public List<Discussion> getSnippetDiscussions(Object projectIdOrPath, Integer snippetId) throws GitLabApiException {
        Pager<Discussion> pager = this.getSnippetDiscussionsPager(projectIdOrPath, snippetId, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getSnippetDiscussions(Object projectIdOrPath, Integer snippetId, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getSnippetDiscussions(projectIdOrPath, snippetId);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "discussions");
        return response.readEntity(new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getSnippetDiscussionsPager(Object projectIdOrPath, Integer snippetId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "discussions");
    }

    public Stream<Discussion> getSnippetDiscussionsStream(Object projectIdOrPath, Integer snippetId) throws GitLabApiException {
        Pager<Discussion> pager = this.getSnippetDiscussionsPager(projectIdOrPath, snippetId, this.getDefaultPerPage());
        return pager.stream();
    }

    public List<Discussion> getEpicDiscussions(Object projectIdOrPath, Integer epicId) throws GitLabApiException {
        Pager<Discussion> pager = this.getEpicDiscussionsPager(projectIdOrPath, epicId, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getEpicDiscussions(Object projectIdOrPath, Integer epicId, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getEpicDiscussions(projectIdOrPath, epicId);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "epics", epicId, "discussions");
        return response.readEntity(new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getEpicDiscussionsPager(Object projectIdOrPath, Integer epicId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "epics", epicId, "discussions");
    }

    public Stream<Discussion> getEpicDiscussionsStream(Object projectIdOrPath, Integer epicId) throws GitLabApiException {
        Pager<Discussion> pager = this.getEpicDiscussionsPager(projectIdOrPath, epicId, this.getDefaultPerPage());
        return pager.stream();
    }

    public List<Discussion> getMergeRequestDiscussions(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        Pager<Discussion> pager = this.getMergeRequestDiscussionsPager(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getMergeRequestDiscussions(Object projectIdOrPath, Integer mergeRequestIid, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getMergeRequestDiscussions(projectIdOrPath, mergeRequestIid);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "discussions");
        return response.readEntity(new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getMergeRequestDiscussionsPager(Object projectIdOrPath, Integer mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "discussions");
    }

    public Stream<Discussion> getMergeRequestDiscussionsStream(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        Pager<Discussion> pager = this.getMergeRequestDiscussionsPager(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage());
        return pager.stream();
    }

    public Discussion createMergeRequestDiscussion(Object projectIdOrPath, Integer mergeRequestIid, String body, Date createdAt, String positionHash, Position position) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("created_at", createdAt).withParam("position", positionHash);
        if (position != null) {
            formData.withParam("position[base_sha]", position.getBaseSha(), true).withParam("position[start_sha]", position.getStartSha(), true).withParam("position[head_sha]", position.getHeadSha(), true).withParam("position[position_type]", (Object)position.getPositionType(), true).withParam("position[new_path]", position.getNewPath()).withParam("position[new_line]", position.getNewLine()).withParam("position[old_path]", position.getOldPath()).withParam("position[old_line]", position.getOldLine()).withParam("position[width]", position.getWidth()).withParam("position[height]", position.getHeight()).withParam("position[x]", position.getX()).withParam("position[y]", position.getY());
        }
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "discussions");
        return response.readEntity(Discussion.class);
    }

    public Discussion resolveMergeRequestDiscussion(Object projectIdOrPath, Integer mergeRequestIid, String discussionId, Boolean resolved) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("resolved", resolved, true);
        Response response = this.put(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "discussions");
        return response.readEntity(Discussion.class);
    }

    public void deleteMergeRequestDiscussionNote(Object projectIdOrPath, Integer mergeRequestIid, String discussionId, Integer noteId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "discussions", noteId);
    }

    public List<Discussion> getCommitDiscussions(Object projectIdOrPath, String commitSha) throws GitLabApiException {
        Pager<Discussion> pager = this.getCommitDiscussionsPager(projectIdOrPath, commitSha, this.getDefaultPerPage());
        return pager.all();
    }

    public List<Discussion> getCommitDiscussions(Object projectIdOrPath, String commitSha, int maxItems) throws GitLabApiException {
        if (maxItems < 1) {
            return this.getCommitDiscussions(projectIdOrPath, commitSha);
        }
        Response response = this.get(Response.Status.OK, this.getPerPageQueryParam(maxItems), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", commitSha, "discussions");
        return response.readEntity(new GenericType<List<Discussion>>(){});
    }

    public Pager<Discussion> getCommitDiscussionsPager(Object projectIdOrPath, String commitSha, int itemsPerPage) throws GitLabApiException {
        return new Pager<Discussion>(this, Discussion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", commitSha, "discussions");
    }

    public Stream<Discussion> getCommitDiscussionsStream(Object projectIdOrPath, String commitSha) throws GitLabApiException {
        Pager<Discussion> pager = this.getCommitDiscussionsPager(projectIdOrPath, commitSha, this.getDefaultPerPage());
        return pager.stream();
    }

    public Discussion getCommitDiscussion(Object projectIdOrPath, String commitSha, String discussionId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", commitSha, "discussions", discussionId);
        return response.readEntity(Discussion.class);
    }

    public Optional<Discussion> getOptionalCommitDiscussion(Object projectIdOrPath, String commitSha, String discussionId) {
        try {
            return Optional.ofNullable(this.getCommitDiscussion(projectIdOrPath, commitSha, discussionId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Discussion createCommitDiscussion(Object projectIdOrPath, String commitSha, String body, Date createdAt, String positionHash, Position position) throws GitLabApiException {
        if (position == null) {
            throw new GitLabApiException("position instance can not be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("created_at", createdAt).withParam("position", positionHash).withParam("position[base_sha]", position.getBaseSha(), true).withParam("position[start_sha]", position.getStartSha(), true).withParam("position[head_sha]", position.getHeadSha(), true).withParam("position[position_type]", (Object)position.getPositionType(), true).withParam("position[new_path]", position.getNewPath()).withParam("position[new_line]", position.getNewLine()).withParam("position[old_path]", position.getOldPath()).withParam("position[old_line]", position.getOldLine()).withParam("position[width]", position.getWidth()).withParam("position[height]", position.getHeight()).withParam("position[x]", position.getX()).withParam("position[y]", position.getY());
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", commitSha, "discussions");
        return response.readEntity(Discussion.class);
    }

    public Note addCommitDiscussionNote(Object projectIdOrPath, String commitSha, String discussionId, String body, Date createdAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("created_at", createdAt);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", commitSha, "discussions", discussionId, "notes");
        return response.readEntity(Note.class);
    }

    public Note modifyCommitDiscussionNote(Object projectIdOrPath, String commitSha, String discussionId, Integer noteId, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", commitSha, "discussions", discussionId, "notes", noteId);
        return response.readEntity(Note.class);
    }

    public Note resolveCommitDiscussionNote(Object projectIdOrPath, String commitSha, String discussionId, Integer noteId, Boolean resolved) throws GitLabApiException {
        GitLabApiForm queryParams = new GitLabApiForm().withParam("resolved", resolved);
        Response response = this.put(Response.Status.OK, queryParams.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", commitSha, "discussions", discussionId, "notes", noteId);
        return response.readEntity(Note.class);
    }

    public void deleteCommitDiscussionNote(Object projectIdOrPath, String commitSha, String discussionId, Integer noteId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", commitSha, "discussions", discussionId, "notes", noteId);
    }
}

