/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class ProxyClientConfig {
    public static Map<String, Object> createProxyClientConfig(String proxyUri) {
        return ProxyClientConfig.createProxyClientConfig(proxyUri, null, null);
    }

    public static Map<String, Object> createProxyClientConfig(String proxyUri, String username, String password) {
        HashMap<String, Object> clientConfig = new HashMap<String, Object>();
        clientConfig.put("jersey.config.client.proxy.uri", proxyUri);
        if (username != null && username.trim().length() > 0) {
            clientConfig.put("jersey.config.client.proxy.username", username);
        }
        if (password != null && password.trim().length() > 0) {
            clientConfig.put("jersey.config.client.proxy.password", password);
        }
        return clientConfig;
    }

    public static Map<String, Object> createNtlmProxyClientConfig(String proxyUri, String username, String password, String workstation, String domain) {
        HashMap<String, Object> clientConfig = new HashMap<String, Object>();
        clientConfig.put("jersey.config.client.proxy.uri", proxyUri);
        BasicCredentialsProvider credentials = new BasicCredentialsProvider();
        credentials.setCredentials(AuthScope.ANY, new NTCredentials(username, password, workstation, domain));
        clientConfig.put("jersey.config.apache.client.credentialsProvider", credentials);
        return clientConfig;
    }
}

