/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Todo;

public class TodosApi
extends AbstractApi {
    public TodosApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Todo> getPendingTodos() throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.PENDING, null, this.getDefaultPerPage()).all();
    }

    public Pager<Todo> getPendingTodos(int itemsPerPage) throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.PENDING, null, itemsPerPage);
    }

    public Stream<Todo> getPendingTodosStream() throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.PENDING, null, this.getDefaultPerPage()).stream();
    }

    public List<Todo> getDoneTodos() throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.DONE, null, this.getDefaultPerPage()).all();
    }

    public Pager<Todo> getDoneTodos(int itemsPerPage) throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.DONE, null, itemsPerPage);
    }

    public Stream<Todo> getDoneTodosStream() throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.DONE, null, this.getDefaultPerPage()).stream();
    }

    public List<Todo> getTodos(Constants.TodoAction action, Integer authorId, Integer projectId, Integer groupId, Constants.TodoState state, Constants.TodoType type) throws GitLabApiException {
        return this.getTodos(action, authorId, projectId, groupId, state, type, this.getDefaultPerPage()).all();
    }

    public Stream<Todo> getTodosStream(Constants.TodoAction action, Integer authorId, Integer projectId, Integer groupId, Constants.TodoState state, Constants.TodoType type) throws GitLabApiException {
        return this.getTodos(action, authorId, projectId, groupId, state, type, this.getDefaultPerPage()).stream();
    }

    public Pager<Todo> getTodos(Constants.TodoAction action, Integer authorId, Integer projectId, Integer groupId, Constants.TodoState state, Constants.TodoType type, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action, false).withParam("author_id", authorId, false).withParam("project_id", projectId, false).withParam("group_id", groupId, false).withParam("state", (Object)state, false).withParam("type", (Object)type, false);
        return new Pager<Todo>(this, Todo.class, itemsPerPage, formData.asMap(), "todos");
    }

    public Todo markAsDone(Integer todoId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        Response response = this.post(Response.Status.OK, (Form)formData, "todos", todoId, "mark_as_done");
        return response.readEntity(Todo.class);
    }

    public void markAllAsDone() throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        this.post(Response.Status.NO_CONTENT, (Form)formData, "todos", "mark_as_done");
    }
}

