/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.WikiAttachment;
import org.gitlab4j.api.models.WikiPage;

public class WikisApi
extends AbstractApi {
    public WikisApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<WikiPage> getPages(Object projectIdOrPath) throws GitLabApiException {
        return this.getPages(projectIdOrPath, 1, this.getDefaultPerPage());
    }

    public List<WikiPage> getPages(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis");
        return response.readEntity(new GenericType<List<WikiPage>>(){});
    }

    public WikiPage getPage(Object projectIdOrPath, String slug) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis", slug);
        return response.readEntity(WikiPage.class);
    }

    public Optional<WikiPage> getOptionalPage(Object projectIdOrPath, String slug) {
        try {
            return Optional.ofNullable(this.getPage(projectIdOrPath, slug));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public WikiPage createPage(Object projectIdOrPath, String title, String content) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("content", content);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis");
        return response.readEntity(WikiPage.class);
    }

    public WikiPage updatePage(Object projectIdOrPath, String slug, String title, String content) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("slug", slug, true).withParam("content", content);
        Response response = this.put(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis", slug);
        return response.readEntity(WikiPage.class);
    }

    public void deletePage(Object projectIdOrPath, String slug) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis", slug);
    }

    public WikiAttachment uploadAttachment(Object projectIdOrPath, File fileToUpload) throws GitLabApiException {
        return this.uploadAttachment(projectIdOrPath, fileToUpload, null);
    }

    public WikiAttachment uploadAttachment(Object projectIdOrPath, File fileToUpload, String branch) throws GitLabApiException {
        URL url;
        try {
            url = this.getApiClient().getApiUrl("projects", this.getProjectIdOrPath(projectIdOrPath), "wikis", "attachments");
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("branch", branch);
        Response response = this.upload(Response.Status.CREATED, "file", fileToUpload, null, formData, url);
        return response.readEntity(WikiAttachment.class);
    }
}

