/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.hk2;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.inject.hk2.AbstractHk2InjectionManager;
import org.glassfish.jersey.inject.spi.BinderConfigurationFactory;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.model.ContractProvider;

public class HK2BinderConfigurationFactory
implements BinderConfigurationFactory {
    @Override
    public BinderConfigurationFactory.BinderConfiguration createBinderConfiguration(Function<Predicate<ContractProvider>, Set<Object>> getInstances) {
        return new HK2BinderConfiguration(getInstances);
    }

    private static class HK2BinderConfiguration
    implements BinderConfigurationFactory.BinderConfiguration {
        private final Function<Predicate<ContractProvider>, Set<Object>> getInstances;
        private static final Predicate<ContractProvider> BINDERS_ONLY = new Predicate<ContractProvider>(){

            @Override
            public boolean test(ContractProvider model) {
                return Binder.class.isAssignableFrom(model.getImplementationClass());
            }
        };
        private static final Function<Object, Binder> CAST_TO_BINDER = new Function<Object, Binder>(){

            @Override
            public Binder apply(Object input) {
                return (Binder)Binder.class.cast(input);
            }
        };
        private Set<Binder> configuredBinders = Collections.emptySet();

        public HK2BinderConfiguration(Function<Predicate<ContractProvider>, Set<Object>> getInstances) {
            this.getInstances = getInstances;
        }

        @Override
        public boolean configureBinders(InjectionManager injectionManager) {
            ServiceLocator serviceLocator = HK2BinderConfiguration.getServiceLocator(injectionManager);
            if (serviceLocator != null) {
                this.configuredBinders = this.configureBinders(serviceLocator, this.configuredBinders);
                return !this.configuredBinders.isEmpty();
            }
            return false;
        }

        private Set<Binder> configureBinders(ServiceLocator locator, Set<Binder> configured) {
            Set<Binder> allConfigured = Collections.newSetFromMap(new IdentityHashMap());
            allConfigured.addAll(configured);
            Collection<Binder> binders = this.getBinders(configured);
            if (!binders.isEmpty()) {
                DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
                DynamicConfiguration dc = dcs.createDynamicConfiguration();
                for (Binder binder : binders) {
                    binder.bind(dc);
                    allConfigured.add(binder);
                }
                dc.commit();
            }
            return allConfigured;
        }

        private Collection<Binder> getBinders(Set<Binder> configured) {
            return this.getInstances.apply(BINDERS_ONLY).stream().map(CAST_TO_BINDER).filter(binder -> !configured.contains(binder)).collect(Collectors.toList());
        }

        private static ServiceLocator getServiceLocator(InjectionManager injectionManager) {
            if (AbstractHk2InjectionManager.class.isInstance(injectionManager)) {
                return ((AbstractHk2InjectionManager)injectionManager).getServiceLocator();
            }
            return null;
        }
    }
}

