/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.datanucleus.enhancer.RuntimeEnhancer;
import org.datanucleus.util.CommandLine;
import org.datanucleus.util.StringUtils;

public class DataNucleusClassFileTransformer
implements ClassFileTransformer {
    protected RuntimeEnhancer enhancer = new RuntimeEnhancer();
    private CommandLine cmd = new CommandLine();

    public DataNucleusClassFileTransformer() {
        this.cmd.addOption("api", "api", "api", "api");
    }

    public DataNucleusClassFileTransformer(String arguments) {
        String val;
        this.cmd.addOption("api", "api", "api", "api");
        this.cmd.addOption("generatePK", "generatePK", "<generate-pk>", "Generate PK class where needed?");
        this.cmd.addOption("generateConstructor", "generateConstructor", "<generate-constructor>", "Generate default constructor where needed?");
        this.cmd.addOption("detachListener", "detachListener", "<detach-listener>", "Use Detach Listener?");
        if (arguments != null) {
            this.cmd.parse(arguments.split("[\\s,=]+"));
        }
        if (this.cmd.getOptionArg("api") != null) {
            this.enhancer.setApi(this.cmd.getOptionArg("api"));
        }
        if (this.cmd.hasOption("generateConstructor") && (val = this.cmd.getOptionArg("generateConstructor")).equalsIgnoreCase("false")) {
            this.enhancer.setGenerateConstructor(false);
        }
        if (this.cmd.hasOption("generatePK") && (val = this.cmd.getOptionArg("generatePK")).equalsIgnoreCase("false")) {
            this.enhancer.setGeneratePK(false);
        }
        if (this.cmd.hasOption("detachListener") && (val = this.cmd.getOptionArg("detachListener")).equalsIgnoreCase("true")) {
            this.enhancer.setDetachListener(true);
        }
    }

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        instrumentation.addTransformer(new DataNucleusClassFileTransformer(agentArguments));
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String name = StringUtils.replaceAll(className, "/", ".");
        if (name.startsWith("java.")) {
            return null;
        }
        if (name.startsWith("javax.")) {
            return null;
        }
        if (name.startsWith("org.datanucleus.") && !name.startsWith("org.datanucleus.samples") && !name.startsWith("org.datanucleus.test")) {
            return null;
        }
        if (this.cmd.getDefaultArgs() != null && this.cmd.getDefaultArgs().length > 0) {
            String[] classes = this.cmd.getDefaultArgs();
            for (int i = 0; i < classes.length; ++i) {
                if (!name.startsWith(classes[i])) continue;
                return this.enhancer.enhance(name, classfileBuffer, loader);
            }
            return null;
        }
        return this.enhancer.enhance(name, classfileBuffer, loader);
    }
}

