/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.util.ClassUtils;

public class IdentityUtils {
    public static String getIdentityAsString(ApiAdapter api, Object id) {
        if (id == null) {
            return null;
        }
        if (api.isSingleFieldIdentity(id)) {
            return api.getTargetClassNameForSingleFieldIdentity(id) + ":" + api.getTargetKeyForSingleFieldIdentity(id);
        }
        return id.toString();
    }

    public static Object getApplicationIdentityForResultSetRow(ExecutionContext ec, AbstractClassMetaData cmd, Class pcClass, boolean inheritanceCheck, FieldManager resultsFM) {
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            Object id;
            if (pcClass == null) {
                pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
            }
            ApiAdapter api = ec.getApiAdapter();
            int[] pkFieldNums = cmd.getPKMemberPositions();
            Object[] pkFieldValues = new Object[pkFieldNums.length];
            for (int i = 0; i < pkFieldNums.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                pkFieldValues[i] = pkMmd.getType() == Integer.TYPE ? Integer.valueOf(resultsFM.fetchIntField(pkFieldNums[i])) : (pkMmd.getType() == Short.TYPE ? Short.valueOf(resultsFM.fetchShortField(pkFieldNums[i])) : (pkMmd.getType() == Long.TYPE ? Long.valueOf(resultsFM.fetchLongField(pkFieldNums[i])) : (pkMmd.getType() == Character.TYPE ? Character.valueOf(resultsFM.fetchCharField(pkFieldNums[i])) : (pkMmd.getType() == Boolean.TYPE ? Boolean.valueOf(resultsFM.fetchBooleanField(pkFieldNums[i])) : (pkMmd.getType() == Byte.TYPE ? Byte.valueOf(resultsFM.fetchByteField(pkFieldNums[i])) : (pkMmd.getType() == Double.TYPE ? Double.valueOf(resultsFM.fetchDoubleField(pkFieldNums[i])) : (pkMmd.getType() == Float.TYPE ? Float.valueOf(resultsFM.fetchFloatField(pkFieldNums[i])) : (pkMmd.getType() == String.class ? resultsFM.fetchStringField(pkFieldNums[i]) : resultsFM.fetchObjectField(pkFieldNums[i])))))))));
            }
            Class idClass = ec.getClassLoaderResolver().classForName(cmd.getObjectidClass());
            if (cmd.usesSingleFieldIdentityClass()) {
                id = api.getNewSingleFieldIdentity(idClass, pcClass, pkFieldValues[0]);
                if (inheritanceCheck) {
                    if (ec.hasIdentityInCache(id)) {
                        return id;
                    }
                    String[] subclasses = ec.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true);
                    if (subclasses != null) {
                        for (int i = 0; i < subclasses.length; ++i) {
                            Object subid = api.getNewSingleFieldIdentity(idClass, ec.getClassLoaderResolver().classForName(subclasses[i]), api.getTargetKeyForSingleFieldIdentity(id));
                            if (!ec.hasIdentityInCache(subid)) continue;
                            return subid;
                        }
                    }
                    String className = ec.getStoreManager().getClassNameForObjectID(id, ec.getClassLoaderResolver(), ec);
                    return api.getNewSingleFieldIdentity(idClass, ec.getClassLoaderResolver().classForName(className), pkFieldValues[0]);
                }
                return id;
            }
            try {
                id = idClass.newInstance();
                for (int i = 0; i < pkFieldNums.length; ++i) {
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                    Object value = pkFieldValues[i];
                    if (api.isPersistable(value)) {
                        value = api.getIdForObject(value);
                    }
                    if (pkMmd instanceof FieldMetaData) {
                        Field pkField = ClassUtils.getFieldForClass(idClass, pkMmd.getName());
                        pkField.set(id, value);
                        continue;
                    }
                    Method pkMethod = ClassUtils.getSetterMethodForClass(idClass, pkMmd.getName(), pkMmd.getType());
                    pkMethod.invoke(id, value);
                }
                return id;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static Object getValueForMemberInId(Object id, AbstractMemberMetaData pkMmd) {
        Method getter;
        if (id == null || pkMmd == null || !pkMmd.isPrimaryKey()) {
            return null;
        }
        String memberName = pkMmd.getName();
        Field fld = ClassUtils.getFieldForClass(id.getClass(), memberName);
        if (fld != null && !Modifier.isPrivate(fld.getModifiers())) {
            try {
                return fld.get(id);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((getter = ClassUtils.getGetterMethodForClass(id.getClass(), memberName)) != null && !Modifier.isPrivate(getter.getModifiers())) {
            try {
                return getter.invoke(id, null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getObjectFromIdString(String idStr, AbstractClassMetaData cmd, ExecutionContext ec, boolean checkInheritance) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Object id = null;
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            id = OIDFactory.getInstance(ec.getNucleusContext(), idStr);
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            if (cmd.usesSingleFieldIdentityClass()) {
                id = ec.getApiAdapter().getNewApplicationIdentityObjectId(clr, cmd, idStr);
            } else {
                Class cls = clr.classForName(cmd.getFullClassName());
                id = ec.newObjectId(cls, (Object)idStr);
            }
        }
        return ec.findObject(id, true, checkInheritance, null);
    }

    public static Object getObjectFromIdString(String idStr, AbstractMemberMetaData mmd, int fieldRole, ExecutionContext ec, boolean checkInheritance) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        if (fieldRole == 2 && mmd.getType().isInterface()) {
            String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, fieldRole, clr, ec.getMetaDataManager());
            if (implNames == null || implNames.length == 0) {
                return null;
            }
            AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                OID id = OIDFactory.getInstance(ec.getNucleusContext(), idStr);
                return ec.findObject(id, true, checkInheritance, null);
            }
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                Object id = null;
                for (int i = 0; i < implNames.length; ++i) {
                    if (i != 0) {
                        cmd = ec.getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    }
                    id = cmd.usesSingleFieldIdentityClass() ? ec.getApiAdapter().getNewApplicationIdentityObjectId(clr, cmd, idStr) : ec.newObjectId(clr.classForName(cmd.getFullClassName()), (Object)idStr);
                    try {
                        return ec.findObject(id, true, checkInheritance, null);
                    }
                    catch (NucleusObjectNotFoundException nonfe) {
                        continue;
                    }
                }
            }
        } else {
            AbstractClassMetaData cmd = null;
            cmd = fieldRole == 3 ? mmd.getCollection().getElementClassMetaData(clr, ec.getMetaDataManager()) : (fieldRole == 4 ? mmd.getArray().getElementClassMetaData(clr, ec.getMetaDataManager()) : (fieldRole == 5 ? mmd.getMap().getKeyClassMetaData(clr, ec.getMetaDataManager()) : (fieldRole == 5 ? mmd.getMap().getKeyClassMetaData(clr, ec.getMetaDataManager()) : ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr))));
            Object id = null;
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                id = OIDFactory.getInstance(ec.getNucleusContext(), idStr);
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (cmd.usesSingleFieldIdentityClass()) {
                    String[] subclasses;
                    Class cls = clr.classForName(cmd.getFullClassName());
                    if (Modifier.isAbstract(cls.getModifiers()) && (subclasses = ec.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), false)) != null) {
                        for (int i = 0; i < subclasses.length; ++i) {
                            cls = clr.classForName(subclasses[i]);
                            if (Modifier.isAbstract(cls.getModifiers())) continue;
                            cmd = ec.getMetaDataManager().getMetaDataForClass(cls, clr);
                            break;
                        }
                    }
                    id = ec.getApiAdapter().getNewApplicationIdentityObjectId(clr, cmd, idStr);
                } else {
                    Class cls = clr.classForName(cmd.getFullClassName());
                    id = ec.newObjectId(cls, (Object)idStr);
                }
            }
            return ec.findObject(id, true, checkInheritance, null);
        }
        return null;
    }
}

