/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigInteger;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerStringConverter
implements TypeConverter<BigInteger, String> {
    @Override
    public BigInteger toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new BigInteger(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)BigInteger.class.getName()), nfe);
        }
    }

    @Override
    public String toDatastoreType(BigInteger bi) {
        return bi != null ? bi.toString() : null;
    }
}

