/*
 * Decompiled with CFR 0.152.
 */
package io.transwarp.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ExecShell {
    private static Long TIME_LIMIT = 60000L;
    private static ExecutorService POOL = Executors.newCachedThreadPool();

    public static String exec(String[] cmd) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        if (process == null) {
            System.out.println("execute shell command faild, command is " + cmd);
            return "";
        }
        Future<String> future = POOL.submit(new ShellCallable(process));
        String result = "";
        try {
            result = future.get(TIME_LIMIT, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            future.cancel(true);
            process.destroy();
            System.out.println("command execute is time out , cmd is : " + cmd);
        }
        return result;
    }

    public static void close() {
        POOL.shutdown();
    }

    private ExecShell() {
    }

    private static class ShellCallable
    implements Callable<String> {
        private Process process;

        ShellCallable(Process process) {
            this.process = process;
        }

        @Override
        public String call() throws Exception {
            InputStream error;
            String errorInfo;
            InputStream input = this.process.getInputStream();
            String result = this.getResult(input).trim();
            if (result.equals("") && !(errorInfo = this.getResult(error = this.process.getErrorStream())).equals("")) {
                System.out.println("shell command execute faild, error info is " + errorInfo.trim());
            }
            return result;
        }

        private String getResult(InputStream input) throws Exception {
            byte[] buffer = new byte[1024];
            StringBuffer answer = new StringBuffer();
            int len = -1;
            while ((len = input.read(buffer)) != -1) {
                String str = new String(buffer, 0, len);
                answer.append(str);
            }
            return answer.toString();
        }
    }
}

