/*
 * Decompiled with CFR 0.152.
 */
package io.transwarp.logCheck;

import io.transwarp.api.Check;
import io.transwarp.common.util.ExecShell;
import io.transwarp.common.util.UtilTools;
import io.transwarp.logCheck.SaveLogBean;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCheckImpl
implements Check {
    private static final Logger log = LoggerFactory.getLogger(LogCheckImpl.class);
    private String logPath;
    private String filename;
    private String goalPath;
    private String[] keys;
    private Integer readLineNumber;
    private Long timeRange;
    private SimpleDateFormat dateFormat;
    private String timeStampMatch;
    private Long nowTime;
    private BufferedWriter writer;
    private Integer outputLine = 0;

    public LogCheckImpl(String json) {
        this(JSONObject.fromObject(json));
    }

    public LogCheckImpl(JSONObject json) {
        this.logPath = json.getString("logPath");
        this.filename = json.getString("filename");
        this.goalPath = json.getString("goalPath");
        this.timeRange = json.getLong("timeRange") * 60L * 60L * 1000L;
        this.readLineNumber = json.getInt("readLineNumber");
        this.keys = json.getString("keys").split(",");
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.timeStampMatch = "[0-9]{4}-[0-9]{2}-[0-9]{2}[\\S\\s]*";
        this.nowTime = System.currentTimeMillis();
    }

    @Override
    public void beginCheck() {
        int maxIndex = this.binarySearchFile();
        this.openWriter();
        for (int i = maxIndex; i >= 0; --i) {
            String filePath = this.logPath + this.filename + (i == 0 ? "" : "." + i);
            log.info("is check log file : [{}]", (Object)filePath);
            this.analysisLogFile(filePath);
        }
    }

    @Override
    public void close() {
        try {
            ExecShell.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Integer binarySearchFile() {
        String filePath = this.logPath + this.filename;
        int totalNumber = this.getTotalNumber(filePath);
        log.info("total log file number : [{}]", totalNumber);
        int left = 0;
        int right = totalNumber - 1;
        while (left < right) {
            int mid = (left + right) / 2;
            if (this.isNeedFile(filePath, mid).booleanValue()) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        return right;
    }

    private void openWriter() {
        UtilTools.buildDir(this.goalPath);
        String outputFile = String.format("%sanalysis-%s", this.goalPath, this.filename);
        log.info("output file path : [{}]", (Object)outputFile);
        UtilTools.deleteFile(outputFile);
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Integer getTotalNumber(String filePath) {
        String command = String.format("ls %s* | wc -l", filePath);
        String result = ExecShell.exec(new String[]{"/bin/bash", "-c", command});
        Integer number = 0;
        try {
            number = Integer.valueOf(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean isNeedFile(String filePath, Integer index) {
        Boolean result;
        block14: {
            if (index > 0) {
                filePath = filePath + "." + index;
            }
            result = false;
            BufferedReader read = null;
            try {
                String line;
                read = new BufferedReader(new FileReader(new File(filePath)));
                do {
                    if ((line = read.readLine()) != null) continue;
                    break block14;
                } while (!line.matches(this.timeStampMatch));
                result = this.isInTimeRange(line);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (read != null) {
                    try {
                        read.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisLogFile(String file) {
        SaveLogBean history = new SaveLogBean(this.readLineNumber);
        BufferedReader read = null;
        try {
            read = new BufferedReader(new FileReader(new File(file)));
            StringBuffer buf = new StringBuffer();
            while (true) {
                String line;
                if ((line = read.readLine()) == null) {
                    this.writeInfo(history, buf.toString());
                    break;
                }
                if (line.matches(this.timeStampMatch)) {
                    String value = buf.toString();
                    buf = new StringBuffer();
                    this.writeInfo(history, value);
                }
                buf.append(line).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (read != null) {
                try {
                    read.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void writeInfo(SaveLogBean history, String line) throws Exception {
        if (line.equals("") || !line.matches(this.timeStampMatch) || !this.isInTimeRange(line).booleanValue()) {
            return;
        }
        Boolean hasKeyWord = false;
        for (String key : this.keys) {
            if (line.indexOf(key) == -1) continue;
            hasKeyWord = true;
            break;
        }
        if (hasKeyWord.booleanValue()) {
            List<String> items = history.getAllValue();
            for (String item : items) {
                this.writer.write(item);
            }
            this.writer.write(line);
            this.outputLine = this.readLineNumber;
        } else if (this.outputLine > 0) {
            this.outputLine = this.outputLine - 1;
            this.writer.write(line);
        } else {
            history.addValue(line);
        }
    }

    private Boolean isInTimeRange(String line) throws Exception {
        String[] items = line.split(" ");
        Long timeStamp = this.dateFormat.parse(String.format("%s %s", items[0], items[1])).getTime();
        if (this.nowTime - timeStamp <= this.timeRange) {
            return true;
        }
        return false;
    }
}

