/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonBeanProcessorMatcher;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.CycleDetectionStrategy;
import net.sf.json.util.JavaIdentifierTransformer;
import net.sf.json.util.JsonEventListener;
import net.sf.json.util.NewBeanInstanceStrategy;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang.StringUtils;

public class JsonConfig {
    public static final JsonBeanProcessorMatcher DEFAULT_JSON_BEAN_PROCESSOR_MATCHER = JsonBeanProcessorMatcher.DEFAULT;
    public static final NewBeanInstanceStrategy DEFAULT_NEW_BEAN_INSTANCE_STRATEGY = NewBeanInstanceStrategy.DEFAULT;
    public static final int MODE_LIST = 1;
    public static final int MODE_OBJECT_ARRAY = 2;
    private static final CycleDetectionStrategy DEFAULT_CYCLE_DETECTION_STRATEGY = CycleDetectionStrategy.STRICT;
    private static final String[] DEFAULT_EXCLUDES = new String[]{"class", "declaringClass", "metaClass"};
    private static final JavaIdentifierTransformer DEFAULT_JAVA_IDENTIFIER_TRANSFORMER = JavaIdentifierTransformer.NOOP;
    private static final String[] EMPTY_EXCLUDES = new String[0];
    private int arrayMode = 1;
    private MultiKeyMap beanKeyMap = new MultiKeyMap();
    private MultiKeyMap beanTypeMap = new MultiKeyMap();
    private Map classMap;
    private CycleDetectionStrategy cycleDetectionStrategy = DEFAULT_CYCLE_DETECTION_STRATEGY;
    private List eventListeners = new ArrayList();
    private String[] excludes = EMPTY_EXCLUDES;
    private boolean handleJettisonEmptyElement;
    private boolean handleJettisonSingleElementArray;
    private boolean ignoreDefaultExcludes;
    private boolean ignoreTransientFields;
    private JavaIdentifierTransformer javaIdentifierTransformer = DEFAULT_JAVA_IDENTIFIER_TRANSFORMER;
    private PropertyFilter javaPropertyFilter;
    private JsonBeanProcessorMatcher jsonBeanProcessorMatcher = DEFAULT_JSON_BEAN_PROCESSOR_MATCHER;
    private PropertyFilter jsonPropertyFilter;
    private Map keyMap = new HashMap();
    private NewBeanInstanceStrategy newBeanInstanceStrategy = DEFAULT_NEW_BEAN_INSTANCE_STRATEGY;
    private Map processorMap = new HashMap();
    private Class rootClass;
    private boolean skipJavaIdentifierTransformationInMapKeys;
    private boolean triggerEvents;
    private Map typeMap = new HashMap();

    public synchronized void addJsonEventListener(JsonEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public void clearJsonBeanProcessors() {
        this.processorMap.clear();
    }

    public synchronized void clearJsonEventListeners() {
        this.eventListeners.clear();
    }

    public void clearJsonValueProcessors() {
        this.beanKeyMap.clear();
        this.beanTypeMap.clear();
        this.keyMap.clear();
        this.typeMap.clear();
    }

    public JsonConfig copy() {
        JsonConfig jsc = new JsonConfig();
        jsc.beanKeyMap.putAll((Map)this.beanKeyMap);
        jsc.beanTypeMap.putAll((Map)this.beanTypeMap);
        jsc.classMap = new HashMap();
        if (this.classMap != null) {
            jsc.classMap.putAll(this.classMap);
        }
        jsc.cycleDetectionStrategy = this.cycleDetectionStrategy;
        if (this.eventListeners != null) {
            jsc.eventListeners.addAll(this.eventListeners);
        }
        if (this.excludes != null) {
            jsc.excludes = new String[this.excludes.length];
            System.arraycopy(this.excludes, 0, jsc.excludes, 0, this.excludes.length);
        }
        jsc.handleJettisonEmptyElement = this.handleJettisonEmptyElement;
        jsc.handleJettisonSingleElementArray = this.handleJettisonSingleElementArray;
        jsc.ignoreDefaultExcludes = this.ignoreDefaultExcludes;
        jsc.ignoreTransientFields = this.ignoreTransientFields;
        jsc.javaIdentifierTransformer = this.javaIdentifierTransformer;
        jsc.keyMap.putAll(this.keyMap);
        jsc.processorMap.putAll(this.processorMap);
        jsc.rootClass = this.rootClass;
        jsc.skipJavaIdentifierTransformationInMapKeys = this.skipJavaIdentifierTransformationInMapKeys;
        jsc.triggerEvents = this.triggerEvents;
        jsc.typeMap.putAll(this.typeMap);
        jsc.jsonPropertyFilter = this.jsonPropertyFilter;
        jsc.javaPropertyFilter = this.javaPropertyFilter;
        jsc.jsonBeanProcessorMatcher = this.jsonBeanProcessorMatcher;
        jsc.newBeanInstanceStrategy = this.newBeanInstanceStrategy;
        return jsc;
    }

    public void disableEventTriggering() {
        this.triggerEvents = false;
    }

    public void enableEventTriggering() {
        this.triggerEvents = true;
    }

    public JsonBeanProcessor findJsonBeanProcessor(Class target) {
        Object key = this.jsonBeanProcessorMatcher.getMatch(target, this.processorMap.keySet());
        return (JsonBeanProcessor)this.processorMap.get(key);
    }

    public JsonValueProcessor findJsonValueProcessor(Class propertyType) {
        JsonValueProcessor jsonValueProcessor = null;
        jsonValueProcessor = (JsonValueProcessor)this.typeMap.get(propertyType);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        return null;
    }

    public JsonValueProcessor findJsonValueProcessor(Class beanClass, Class propertyType, String key) {
        JsonValueProcessor jsonValueProcessor = null;
        jsonValueProcessor = (JsonValueProcessor)this.beanKeyMap.get(beanClass, key);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        jsonValueProcessor = (JsonValueProcessor)this.beanTypeMap.get(beanClass, propertyType);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        jsonValueProcessor = (JsonValueProcessor)this.keyMap.get(key);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        jsonValueProcessor = (JsonValueProcessor)this.typeMap.get(propertyType);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        return null;
    }

    public JsonValueProcessor findJsonValueProcessor(Class propertyType, String key) {
        JsonValueProcessor jsonValueProcessor = null;
        jsonValueProcessor = (JsonValueProcessor)this.keyMap.get(key);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        jsonValueProcessor = (JsonValueProcessor)this.typeMap.get(propertyType);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        return null;
    }

    public int getArrayMode() {
        return this.arrayMode;
    }

    public Map getClassMap() {
        return this.classMap;
    }

    public CycleDetectionStrategy getCycleDetectionStrategy() {
        return this.cycleDetectionStrategy;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public JavaIdentifierTransformer getJavaIdentifierTransformer() {
        return this.javaIdentifierTransformer;
    }

    public PropertyFilter getJavaPropertyFilter() {
        return this.javaPropertyFilter;
    }

    public JsonBeanProcessorMatcher getJsonBeanProcessorMatcher() {
        return this.jsonBeanProcessorMatcher;
    }

    public synchronized List getJsonEventListeners() {
        return this.eventListeners;
    }

    public PropertyFilter getJsonPropertyFilter() {
        return this.jsonPropertyFilter;
    }

    public Collection getMergedExcludes() {
        int i;
        HashSet<String> exclusions = new HashSet<String>();
        for (i = 0; i < this.excludes.length; ++i) {
            String exclusion = this.excludes[i];
            if (StringUtils.isBlank(this.excludes[i])) continue;
            exclusions.add(exclusion.trim());
        }
        if (!this.ignoreDefaultExcludes) {
            for (i = 0; i < DEFAULT_EXCLUDES.length; ++i) {
                if (exclusions.contains(DEFAULT_EXCLUDES[i])) continue;
                exclusions.add(DEFAULT_EXCLUDES[i]);
            }
        }
        return exclusions;
    }

    public NewBeanInstanceStrategy getNewBeanInstanceStrategy() {
        return this.newBeanInstanceStrategy;
    }

    public Class getRootClass() {
        return this.rootClass;
    }

    public boolean isEventTriggeringEnabled() {
        return this.triggerEvents;
    }

    public boolean isHandleJettisonEmptyElement() {
        return this.handleJettisonEmptyElement;
    }

    public boolean isHandleJettisonSingleElementArray() {
        return this.handleJettisonSingleElementArray;
    }

    public boolean isIgnoreDefaultExcludes() {
        return this.ignoreDefaultExcludes;
    }

    public boolean isIgnoreTransientFields() {
        return this.ignoreTransientFields;
    }

    public boolean isSkipJavaIdentifierTransformationInMapKeys() {
        return this.skipJavaIdentifierTransformationInMapKeys;
    }

    public void registerJsonBeanProcessor(Class target, JsonBeanProcessor jsonBeanProcessor) {
        if (target != null && jsonBeanProcessor != null) {
            this.processorMap.put(target, jsonBeanProcessor);
        }
    }

    public void registerJsonValueProcessor(Class beanClass, Class propertyType, JsonValueProcessor jsonValueProcessor) {
        if (beanClass != null && propertyType != null && jsonValueProcessor != null) {
            this.beanTypeMap.put(beanClass, propertyType, jsonValueProcessor);
        }
    }

    public void registerJsonValueProcessor(Class propertyType, JsonValueProcessor jsonValueProcessor) {
        if (propertyType != null && jsonValueProcessor != null) {
            this.typeMap.put(propertyType, jsonValueProcessor);
        }
    }

    public void registerJsonValueProcessor(Class beanClass, String key, JsonValueProcessor jsonValueProcessor) {
        if (beanClass != null && key != null && jsonValueProcessor != null) {
            this.beanKeyMap.put(beanClass, key, jsonValueProcessor);
        }
    }

    public void registerJsonValueProcessor(String key, JsonValueProcessor jsonValueProcessor) {
        if (key != null && jsonValueProcessor != null) {
            this.keyMap.put(key, jsonValueProcessor);
        }
    }

    public synchronized void removeJsonEventListener(JsonEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void reset() {
        this.excludes = EMPTY_EXCLUDES;
        this.ignoreDefaultExcludes = false;
        this.ignoreTransientFields = false;
        this.javaIdentifierTransformer = DEFAULT_JAVA_IDENTIFIER_TRANSFORMER;
        this.cycleDetectionStrategy = DEFAULT_CYCLE_DETECTION_STRATEGY;
        this.skipJavaIdentifierTransformationInMapKeys = false;
        this.triggerEvents = false;
        this.handleJettisonEmptyElement = false;
        this.handleJettisonSingleElementArray = false;
        this.arrayMode = 1;
        this.rootClass = null;
        this.classMap = null;
        this.keyMap.clear();
        this.typeMap.clear();
        this.beanKeyMap.clear();
        this.beanTypeMap.clear();
        this.jsonPropertyFilter = null;
        this.javaPropertyFilter = null;
        this.jsonBeanProcessorMatcher = DEFAULT_JSON_BEAN_PROCESSOR_MATCHER;
        this.newBeanInstanceStrategy = DEFAULT_NEW_BEAN_INSTANCE_STRATEGY;
    }

    public void setArrayMode(int arrayMode) {
        this.arrayMode = arrayMode != 1 && arrayMode != 2 ? 1 : arrayMode;
    }

    public void setClassMap(Map classMap) {
        this.classMap = classMap;
    }

    public void setCycleDetectionStrategy(CycleDetectionStrategy cycleDetectionStrategy) {
        this.cycleDetectionStrategy = cycleDetectionStrategy == null ? DEFAULT_CYCLE_DETECTION_STRATEGY : cycleDetectionStrategy;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes == null ? EMPTY_EXCLUDES : excludes;
    }

    public void setHandleJettisonEmptyElement(boolean handleJettisonEmptyElement) {
        this.handleJettisonEmptyElement = handleJettisonEmptyElement;
    }

    public void setHandleJettisonSingleElementArray(boolean handleJettisonSingleElementArray) {
        this.handleJettisonSingleElementArray = handleJettisonSingleElementArray;
    }

    public void setIgnoreDefaultExcludes(boolean ignoreDefaultExcludes) {
        this.ignoreDefaultExcludes = ignoreDefaultExcludes;
    }

    public void setIgnoreTransientFields(boolean ignoreTransientFields) {
        this.ignoreTransientFields = ignoreTransientFields;
    }

    public void setJavaIdentifierTransformer(JavaIdentifierTransformer javaIdentifierTransformer) {
        this.javaIdentifierTransformer = javaIdentifierTransformer == null ? DEFAULT_JAVA_IDENTIFIER_TRANSFORMER : javaIdentifierTransformer;
    }

    public void setJavaPropertyFilter(PropertyFilter javaPropertyFilter) {
        this.javaPropertyFilter = javaPropertyFilter;
    }

    public void setJsonBeanProcessorMatcher(JsonBeanProcessorMatcher jsonBeanProcessorMatcher) {
        this.jsonBeanProcessorMatcher = jsonBeanProcessorMatcher == null ? DEFAULT_JSON_BEAN_PROCESSOR_MATCHER : jsonBeanProcessorMatcher;
    }

    public void setJsonPropertyFilter(PropertyFilter jsonPropertyFilter) {
        this.jsonPropertyFilter = jsonPropertyFilter;
    }

    public void setNewBeanInstanceStrategy(NewBeanInstanceStrategy newBeanInstanceStrategy) {
        this.newBeanInstanceStrategy = newBeanInstanceStrategy == null ? DEFAULT_NEW_BEAN_INSTANCE_STRATEGY : newBeanInstanceStrategy;
    }

    public void setRootClass(Class rootClass) {
        this.rootClass = rootClass;
    }

    public void setSkipJavaIdentifierTransformationInMapKeys(boolean skipJavaIdentifierTransformationInMapKeys) {
        this.skipJavaIdentifierTransformationInMapKeys = skipJavaIdentifierTransformationInMapKeys;
    }

    public void unregisterJsonBeanProcessor(Class target) {
        if (target != null) {
            this.processorMap.remove(target);
        }
    }

    public void unregisterJsonValueProcessor(Class propertyType) {
        if (propertyType != null) {
            this.typeMap.remove(propertyType);
        }
    }

    public void unregisterJsonValueProcessor(Class beanClass, Class propertyType) {
        if (beanClass != null && propertyType != null) {
            this.beanTypeMap.remove(beanClass, propertyType);
        }
    }

    public void unregisterJsonValueProcessor(Class beanClass, String key) {
        if (beanClass != null && key != null) {
            this.beanKeyMap.remove(beanClass, key);
        }
    }

    public void unregisterJsonValueProcessor(String key) {
        if (key != null) {
            this.keyMap.remove(key);
        }
    }
}

