/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;

public final class SlowCodecReaderWrapper {
    private SlowCodecReaderWrapper() {
    }

    public static CodecReader wrap(final LeafReader reader) throws IOException {
        if (reader instanceof CodecReader) {
            return (CodecReader)reader;
        }
        reader.checkIntegrity();
        return new CodecReader(){

            @Override
            public TermVectorsReader getTermVectorsReader() {
                reader.ensureOpen();
                return SlowCodecReaderWrapper.readerToTermVectorsReader(reader);
            }

            @Override
            public StoredFieldsReader getFieldsReader() {
                reader.ensureOpen();
                return SlowCodecReaderWrapper.readerToStoredFieldsReader(reader);
            }

            @Override
            public StoredFieldsReader getFieldsMergingReader() {
                StoredFieldsReader ret = null;
                try {
                    ret = this.getFieldsReader().getMergeInstance();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return ret;
            }

            @Override
            public NormsProducer getNormsReader() {
                reader.ensureOpen();
                return SlowCodecReaderWrapper.readerToNormsProducer(reader);
            }

            @Override
            public DocValuesProducer getDocValuesReader() {
                reader.ensureOpen();
                return SlowCodecReaderWrapper.readerToDocValuesProducer(reader);
            }

            @Override
            public FieldsProducer getPostingsReader() {
                reader.ensureOpen();
                try {
                    return SlowCodecReaderWrapper.readerToFieldsProducer(reader);
                }
                catch (IOException bogus) {
                    throw new AssertionError((Object)bogus);
                }
            }

            @Override
            public FieldInfos getFieldInfos() {
                return reader.getFieldInfos();
            }

            @Override
            public Bits getLiveDocs() {
                return reader.getLiveDocs();
            }

            @Override
            public int numDocs() {
                return reader.numDocs();
            }

            @Override
            public int maxDoc() {
                return reader.maxDoc();
            }

            @Override
            public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
                reader.addCoreClosedListener(listener);
            }

            @Override
            public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
                reader.removeCoreClosedListener(listener);
            }
        };
    }

    private static NormsProducer readerToNormsProducer(final LeafReader reader) {
        return new NormsProducer(){

            @Override
            public NumericDocValues getNorms(FieldInfo field) throws IOException {
                return reader.getNormValues(field.name);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    private static DocValuesProducer readerToDocValuesProducer(final LeafReader reader) {
        return new DocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                return reader.getNumericDocValues(field.name);
            }

            @Override
            public BinaryDocValues getBinary(FieldInfo field) throws IOException {
                return reader.getBinaryDocValues(field.name);
            }

            @Override
            public SortedDocValues getSorted(FieldInfo field) throws IOException {
                return reader.getSortedDocValues(field.name);
            }

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                return reader.getSortedNumericDocValues(field.name);
            }

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
                return reader.getSortedSetDocValues(field.name);
            }

            @Override
            public Bits getDocsWithField(FieldInfo field) throws IOException {
                return reader.getDocsWithField(field.name);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    private static StoredFieldsReader readerToStoredFieldsReader(final LeafReader reader) {
        return new StoredFieldsReader(){

            @Override
            public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
                reader.document(docID, visitor);
            }

            @Override
            public StoredFieldsReader clone() {
                return SlowCodecReaderWrapper.readerToStoredFieldsReader(reader);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    private static TermVectorsReader readerToTermVectorsReader(final LeafReader reader) {
        return new TermVectorsReader(){

            @Override
            public Fields get(int docID) throws IOException {
                return reader.getTermVectors(docID);
            }

            @Override
            public TermVectorsReader clone() {
                return SlowCodecReaderWrapper.readerToTermVectorsReader(reader);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    private static FieldsProducer readerToFieldsProducer(LeafReader reader) throws IOException {
        final Fields fields = reader.fields();
        return new FieldsProducer(){

            @Override
            public Iterator<String> iterator() {
                return fields.iterator();
            }

            @Override
            public Terms terms(String field) throws IOException {
                return fields.terms(field);
            }

            @Override
            public int size() {
                return fields.size();
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }
}

