/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.nio.ByteBuffer;
import org.apache.lucene.util.fst.FST;

final class DirectForwardBytesReader
extends FST.BytesReader {
    private final ByteBuffer bytes;

    public DirectForwardBytesReader(ByteBuffer bytes) {
        if (bytes.position() != 0) {
            throw new IllegalArgumentException("byte buffer init position must be zero");
        }
        this.bytes = bytes.slice();
    }

    @Override
    public byte readByte() {
        return this.bytes.get();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        this.bytes.get(b, offset, len);
    }

    @Override
    public void skipBytes(long count) {
        this.bytes.position((int)((long)this.bytes.position() + count));
    }

    @Override
    public long getPosition() {
        return this.bytes.position();
    }

    @Override
    public void setPosition(long pos) {
        this.bytes.position((int)pos);
    }

    @Override
    public boolean reversed() {
        return false;
    }
}

