/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.fst.FST;

public class DirectForwardMultiBytesReader
extends FST.BytesReader {
    private final List<ByteBuffer> buffers;
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private ByteBuffer current;
    private int nextBuffer;
    private int nextRead;

    public DirectForwardMultiBytesReader(List<ByteBuffer> list, int blockSize, int blockBits, int blockMask) {
        this.buffers = new ArrayList<ByteBuffer>(list.size());
        for (int i = 0; i < this.buffers.size(); ++i) {
            if (list.get(i).position() != 0) {
                throw new IllegalArgumentException("byte buffer init position must be zero");
            }
            this.buffers.add(list.get(i).slice());
        }
        this.blockSize = blockSize;
        this.blockBits = blockBits;
        this.blockMask = blockMask;
        this.nextRead = blockSize;
    }

    @Override
    public long getPosition() {
        return ((long)this.nextBuffer - 1L) * (long)this.blockSize + (long)this.nextRead;
    }

    @Override
    public void setPosition(long pos) {
        int bufferIndex = (int)(pos >> this.blockBits);
        this.nextBuffer = bufferIndex + 1;
        this.current = this.buffers.get(bufferIndex);
        this.nextRead = (int)(pos & (long)this.blockMask);
        assert (this.getPosition() == pos);
    }

    @Override
    public boolean reversed() {
        return false;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.nextRead == this.blockSize) {
            this.current = this.buffers.get(this.nextBuffer++);
            this.nextRead = 0;
        }
        return this.current.get(this.nextRead++);
    }

    @Override
    public void skipBytes(long count) {
        this.setPosition(this.getPosition() + count);
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int chunkLeft = this.blockSize - this.nextRead;
            if (len <= chunkLeft) {
                this.current.position(this.nextRead);
                this.current.get(b, offset, len);
                this.nextRead += len;
                break;
            }
            if (chunkLeft > 0) {
                this.current.position(this.nextRead);
                this.current.get(b, offset, chunkLeft);
                offset += chunkLeft;
                len -= chunkLeft;
            }
            this.current = this.buffers.get(this.nextBuffer++);
            this.nextRead = 0;
        }
    }
}

