/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.nio.ByteBuffer;
import org.apache.lucene.util.fst.FST;

final class DirectReverseBytesReader
extends FST.BytesReader {
    private final ByteBuffer bytes;
    private int pos;

    public DirectReverseBytesReader(ByteBuffer bytes) {
        if (bytes.position() != 0) {
            throw new IllegalArgumentException("byte buffer init position must be zero");
        }
        this.bytes = bytes.slice();
    }

    @Override
    public byte readByte() {
        return this.bytes.get(this.pos--);
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        this.bytes.position(this.pos - len + 1);
        this.bytes.get(b, offset, len);
        this.pos -= len;
        int start = offset;
        for (int end = offset + len - 1; end > start; --end) {
            int n = start;
            b[n] = (byte)(b[n] ^ b[end]);
            int n2 = end;
            b[n2] = (byte)(b[n2] ^ b[start]);
            int n3 = start++;
            b[n3] = (byte)(b[n3] ^ b[end]);
        }
    }

    @Override
    public void skipBytes(long count) {
        this.pos = (int)((long)this.pos - count);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(long pos) {
        this.pos = (int)pos;
    }

    @Override
    public boolean reversed() {
        return true;
    }

    public static void main(String[] args) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10);
        for (int i = 0; i < 10; ++i) {
            buffer.put((byte)i);
        }
        buffer.flip();
        DirectReverseBytesReader reader = new DirectReverseBytesReader(buffer);
        reader.setPosition(9L);
        byte[] b = new byte[10];
        reader.readBytes(b, 0, 10);
        for (int i = 0; i < 10; ++i) {
            System.err.println(b[i]);
        }
    }
}

