/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.fst.FST;

final class DirectReverseMultiBytesReader
extends FST.BytesReader {
    private final List<ByteBuffer> buffers;
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private ByteBuffer current;
    private int nextBuffer;
    private int nextRead;

    public DirectReverseMultiBytesReader(List<ByteBuffer> list, int blockSize, int blockBits, int blockMask) {
        this.buffers = new ArrayList<ByteBuffer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).position() != 0) {
                throw new IllegalArgumentException("byte buffer init position must be zero");
            }
            this.buffers.add(list.get(i).slice());
        }
        this.blockSize = blockSize;
        this.blockBits = blockBits;
        this.blockMask = blockMask;
        this.current = this.buffers.size() == 0 ? null : this.buffers.get(0);
        this.nextRead = 0;
        this.nextBuffer = -1;
    }

    @Override
    public byte readByte() {
        if (this.nextRead == -1) {
            this.current = this.buffers.get(this.nextBuffer--);
            this.nextRead = this.blockSize - 1;
        }
        return this.current.get(this.nextRead--);
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            b[offset + i] = this.readByte();
        }
    }

    @Override
    public void skipBytes(long count) {
        this.setPosition(this.getPosition() - count);
    }

    @Override
    public long getPosition() {
        return ((long)this.nextBuffer + 1L) * (long)this.blockSize + (long)this.nextRead;
    }

    @Override
    public void setPosition(long pos) {
        int bufferIndex = (int)(pos >> this.blockBits);
        this.nextBuffer = bufferIndex - 1;
        this.current = this.buffers.get(bufferIndex);
        this.nextRead = (int)(pos & (long)this.blockMask);
        assert (this.getPosition() == pos) : "pos=" + pos + " getPos()=" + this.getPosition();
    }

    @Override
    public boolean reversed() {
        return true;
    }
}

