/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.scram;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialCallback;
import org.apache.kafka.common.security.scram.ScramFormatter;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.apache.kafka.common.security.scram.ScramMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScramSaslServer
implements SaslServer {
    private static final Logger log = LoggerFactory.getLogger(ScramSaslServer.class);
    private final ScramMechanism mechanism;
    private final ScramFormatter formatter;
    private final CallbackHandler callbackHandler;
    private State state;
    private String username;
    private ScramMessages.ClientFirstMessage clientFirstMessage;
    private ScramMessages.ServerFirstMessage serverFirstMessage;
    private String serverNonce;
    private ScramCredential scramCredential;

    public ScramSaslServer(ScramMechanism mechanism, Map<String, ?> props, CallbackHandler callbackHandler) throws NoSuchAlgorithmException {
        this.mechanism = mechanism;
        this.formatter = new ScramFormatter(mechanism);
        this.callbackHandler = callbackHandler;
        this.setState(State.RECEIVE_CLIENT_FIRST_MESSAGE);
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            switch (this.state) {
                case RECEIVE_CLIENT_FIRST_MESSAGE: {
                    this.clientFirstMessage = new ScramMessages.ClientFirstMessage(response);
                    this.serverNonce = this.formatter.secureRandomString();
                    try {
                        String saslName = this.clientFirstMessage.saslName();
                        this.username = this.formatter.username(saslName);
                        NameCallback nameCallback = new NameCallback("username", this.username);
                        ScramCredentialCallback credentialCallback = new ScramCredentialCallback();
                        this.callbackHandler.handle(new Callback[]{nameCallback, credentialCallback});
                        this.scramCredential = credentialCallback.scramCredential();
                        if (this.scramCredential == null) {
                            throw new SaslException("Authentication failed: Invalid user credentials");
                        }
                        if (this.scramCredential.iterations() < this.mechanism.minIterations()) {
                            throw new SaslException("Iterations " + this.scramCredential.iterations() + " is less than the minimum " + this.mechanism.minIterations() + " for " + (Object)((Object)this.mechanism));
                        }
                        this.serverFirstMessage = new ScramMessages.ServerFirstMessage(this.clientFirstMessage.nonce(), this.serverNonce, this.scramCredential.salt(), this.scramCredential.iterations());
                        this.setState(State.RECEIVE_CLIENT_FINAL_MESSAGE);
                        return this.serverFirstMessage.toBytes();
                    }
                    catch (IOException | NumberFormatException | UnsupportedCallbackException e) {
                        throw new SaslException("Authentication failed: Credentials could not be obtained", e);
                    }
                }
                case RECEIVE_CLIENT_FINAL_MESSAGE: {
                    try {
                        ScramMessages.ClientFinalMessage clientFinalMessage = new ScramMessages.ClientFinalMessage(response);
                        this.verifyClientProof(clientFinalMessage);
                        byte[] serverKey = this.scramCredential.serverKey();
                        byte[] serverSignature = this.formatter.serverSignature(serverKey, this.clientFirstMessage, this.serverFirstMessage, clientFinalMessage);
                        ScramMessages.ServerFinalMessage serverFinalMessage = new ScramMessages.ServerFinalMessage(null, serverSignature);
                        this.setState(State.COMPLETE);
                        return serverFinalMessage.toBytes();
                    }
                    catch (InvalidKeyException e) {
                        throw new SaslException("Authentication failed: Invalid client final message", e);
                    }
                }
            }
            throw new IllegalSaslStateException("Unexpected challenge in Sasl server state " + (Object)((Object)this.state));
        }
        catch (SaslException e) {
            this.setState(State.FAILED);
            throw e;
        }
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        String authzId = this.clientFirstMessage.authorizationId();
        return authzId == null || authzId.length() == 0 ? this.username : authzId;
    }

    @Override
    public String getMechanismName() {
        return this.mechanism.mechanismName();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.state == State.COMPLETE;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public void dispose() throws SaslException {
    }

    private void setState(State state) {
        log.debug("Setting SASL/{} server state to {}", (Object)this.mechanism, (Object)state);
        this.state = state;
    }

    private void verifyClientProof(ScramMessages.ClientFinalMessage clientFinalMessage) throws SaslException {
        try {
            byte[] expectedStoredKey = this.scramCredential.storedKey();
            byte[] clientSignature = this.formatter.clientSignature(expectedStoredKey, this.clientFirstMessage, this.serverFirstMessage, clientFinalMessage);
            byte[] computedStoredKey = this.formatter.storedKey(clientSignature, clientFinalMessage.proof());
            if (!Arrays.equals(computedStoredKey, expectedStoredKey)) {
                throw new SaslException("Invalid client credentials");
            }
        }
        catch (InvalidKeyException e) {
            throw new SaslException("Sasl client verification failed", e);
        }
    }

    public static class ScramSaslServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            if (!ScramMechanism.isScram(mechanism)) {
                throw new SaslException(String.format("Requested mechanism '%s' is not supported. Supported mechanisms are '%s'.", mechanism, ScramMechanism.mechanismNames()));
            }
            try {
                return new ScramSaslServer(ScramMechanism.forMechanismName(mechanism), props, cbh);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Hash algorithm not supported for mechanism " + mechanism, e);
            }
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            Collection<String> mechanisms = ScramMechanism.mechanismNames();
            return mechanisms.toArray(new String[mechanisms.size()]);
        }
    }

    static enum State {
        RECEIVE_CLIENT_FIRST_MESSAGE,
        RECEIVE_CLIENT_FINAL_MESSAGE,
        COMPLETE,
        FAILED;

    }
}

