package io.transwarp.cluster.comparison;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.report.comparison.Comparison;

public class ClusterComparisonImpl implements Comparison {

	private final InspectionData data;
	private final ComparisonResultOfCluster comparisonResult;
	private final String[] checkItems = new String[]{"roleMap"};
	
	public ClusterComparisonImpl(final ComparisonResultOfCluster comparisonResult,
			final InspectionData data) {
		this.data = data;
		this.comparisonResult = comparisonResult;
	}
	
	@Override
	public void comparison() throws Exception {
		Comparison comparison = null;
		for (String checkItem : checkItems) {
			comparison = buildComparisonItem(checkItem);
			if (comparison == null) {
				continue;
			}
			try {
				comparison.comparison();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	private Comparison buildComparisonItem(String checkItem) {
		if (checkItem.equals("roleMap")) {
			return new RoleMapComparisonImpl(comparisonResult, data);
		}
		throw new RuntimeException("no find this check item : " + checkItem);
	}
}
