package io.transwarp.cluster.comparison;

import io.transwarp.common.util.UtilTools;

import java.util.ArrayList;
import java.util.List;

public class ResourceOnNode {

	private List<String> resourceInfos;
	private String totalMemory;
	private String totalCores;
	private Double allocatedMemory;
	private Double allocatedCores;
	
	public ResourceOnNode(final String totalMemory, final String totalCores) {
		this.totalCores = totalCores;
		this.totalMemory = totalMemory;
		this.resourceInfos = new ArrayList<String>();
		allocatedMemory = 0.0;
		allocatedCores = 0.0;
	}
	
	public void addNewResource(final int id, final String value) {
		analysisValue(value);
		while (this.resourceInfos.size() <= id) {
			this.resourceInfos.add("");
		}
		this.resourceInfos.set(id, value);
	}
	
	@Override
	public String toString() {
		StringBuffer result = new StringBuffer();
		for (String resourceInfo : resourceInfos) {
			result.append(resourceInfo).append("\n");
		}
		result.append(allocatedMemory).append("\n")
			.append(allocatedCores).append("\n")
			.append(totalMemory).append("\n")
			.append(totalCores);
		return result.toString();
	}
	
	@Override
	public boolean equals(Object other) {
		if (other == null) {
			return false;
		}
		if (this.toString().equals(other.toString())) {
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		return this.toString().hashCode();
	}
	
	private void analysisValue(final String value) {
		String[] splitItems = value.split(",");
		int number = 1;
		for(String splitItem : splitItems) {
			splitItem = splitItem.trim();
			String[] items = splitItem.split(":");
			if (items.length < 2) {
				continue;
			}
			String key = items[0].trim();
			if (key.equals("active number")) {
				number = Integer.valueOf(UtilTools.numberFormat(items[1]));
			} else if (key.equals("memory")) {
				allocatedMemory += number * UtilTools.getValueFromSize(items[1]);
			} else if (key.equals("core")) {
				allocatedCores += number * UtilTools.getValueFromSize(items[1]);
			}
		}
	}
	
	public String getResource(int index) {
		if (index >= this.resourceInfos.size()) {
			return "";
		} else {
			return this.resourceInfos.get(index);
		}
	}
	
	public String getTotalMemory() {
		return "Memory : " + this.totalMemory;
	}
	
	public String getTotalCores() {
		return "Cores : " + this.totalCores;
	}
	
	public String getAllocatedMemory() {
		return "Memory : " + UtilTools.getCarrySize(this.allocatedMemory.longValue());
	}
	
	public String getAllocatedCores() {
		return "Cores : " + this.allocatedCores;
	}
}
