package io.transwarp.cluster.report;

import java.text.SimpleDateFormat;
import java.util.Vector;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.AlertBean;
import io.transwarp.common.bean.ClusterInfo;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class AlertXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final ClusterInfo clusterInfo;
	private final SimpleDateFormat dateFormat;
	private int maxCol;

	public AlertXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final ClusterInfo clusterInfo) {
		this.sheet = workbook.createSheet("alert", checkItem.ordinal());
		this.clusterInfo = clusterInfo;
		this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		this.maxCol = 0;
	}
	
	@Override
	public void writeSheet() throws Exception {
		int beginRow = 1;
		Vector<AlertBean> alerts = clusterInfo.getAlerts();
		if (alerts.size() == 0) {
			sheet.addCell(new Label(0, 0, "there is no active alert", CELL_THIN));
			return;
		}
		writeTitle(beginRow);
		beginRow += 1;
		Vector<String> alertInfos = new Vector<String>();
		for (AlertBean alert : alerts) {
			writeAlertInfo(beginRow, alert);
			alertInfos.add(String.format("title : %s, contextName : %s, description : %s", alert.getTitle(), alert.getContextName(), alert.getDescription()));
			beginRow += 1;
		}
		for (int i = 0; i < maxCol - 1; i++) {
			sheet.setColumnView(i, 20);
		}
		sheet.setColumnView(maxCol - 1, 30);
	}
	
	private void writeTitle(final int beginRow) throws Exception {
		int column = 0;
		sheet.addCell(new Label(column++, beginRow, "时间", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "标题", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "级别", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "分类", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "涉及资源名", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "涉及资源子项目", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "描述", CELL_BOLD));
		maxCol = Math.max(maxCol, column);
	}
	
	private void writeAlertInfo(int beginRow, final AlertBean alert) throws Exception {
		int column = 0;
		sheet.addCell(new Label(column++, beginRow, dateFormat.format(Long.valueOf(alert.getTimeStamp())), CELL_THIN));
		sheet.addCell(new Label(column++, beginRow, alert.getTitle(), CELL_THIN));
		sheet.addCell(new Label(column++, beginRow, alert.getSeverity(), CELL_THIN));
		sheet.addCell(new Label(column++, beginRow, alert.getCategory(), CELL_THIN));
		sheet.addCell(new Label(column++, beginRow, alert.getContextName(), CELL_THIN));
		sheet.addCell(new Label(column++, beginRow, alert.getSubId(), CELL_THIN));
		sheet.addCell(new Label(column++, beginRow, alert.getDescription(), CELL_THIN));		
	}
}
