package io.transwarp.cluster.report;

import java.util.List;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.LicenseBean;
import io.transwarp.common.bean.LicenseBean.ComponentBean;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class LicenseXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final LicenseBean license;
	
	private int maxCol;

	public LicenseXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final LicenseBean license) {
		this.sheet = workbook.createSheet("license", checkItem.ordinal());
		this.license = license;
		this.maxCol = 0;
	}
	
	@Override
	public void writeSheet() throws Exception {
		int beginRow = 0;
		writeTitle(beginRow);
		writeLicenseInfo(beginRow);
		for (int i = 0; i < maxCol; i++) {
			sheet.setColumnView(i, 20);
		}
	}
	
	private void writeTitle(int beginRow) throws Exception {
		sheet.addCell(new Label(0, beginRow++, "clusterSize", CELL_BOLD));
		sheet.addCell(new Label(0, beginRow++, "supportStartDay", CELL_BOLD));
		sheet.addCell(new Label(0, beginRow++, "serverKey", CELL_BOLD));
		sheet.addCell(new Label(0, beginRow++, "serialNumber", CELL_BOLD));
		
		beginRow += 1;
		int column = 0;
		sheet.addCell(new Label(column++, beginRow, "compType", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "compTypeFriendly", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "compSize", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "licenseType", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "expiredDate", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "supportExpiration", CELL_BOLD));
		this.maxCol = Math.max(maxCol, column);
		
	}
	
	private void writeLicenseInfo(int beginRow) throws Exception {
		sheet.addCell(new Label(1, beginRow++, license.getClusterSize(), CELL_THIN));
		sheet.addCell(new Label(1, beginRow++, license.getSupportStartDay(), CELL_THIN));
		sheet.addCell(new Label(1, beginRow++, license.getServerKey(), CELL_THIN));
		sheet.addCell(new Label(1, beginRow++, license.getSerialNumber(), CELL_THIN));
		
		beginRow += 2;
		List<ComponentBean> components = license.getComponents();
		for (ComponentBean component : components) {
			int column = 0;
			sheet.addCell(new Label(column++, beginRow, component.getCompType(), CELL_THIN));
			sheet.addCell(new Label(column++, beginRow, component.getCompTypeFriendly(), CELL_THIN));
			sheet.addCell(new Label(column++, beginRow, component.getCompSize(), CELL_THIN));
			sheet.addCell(new Label(column++, beginRow, component.getLicenseType(), CELL_THIN));
			sheet.addCell(new Label(column++, beginRow, component.getExpiredDate(), CELL_THIN));
			sheet.addCell(new Label(column++, beginRow, component.getSupportExpiration(), CELL_THIN));
			beginRow += 1;
		}
	}
}
