package io.transwarp.cluster.report;

import java.util.Map.Entry;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.NodeInfo;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class VersionXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final NodeInfo nodeInfo;
	
	public VersionXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final NodeInfo nodeInfo) {
		this.sheet = workbook.createSheet("version", checkItem.ordinal());
		this.nodeInfo = nodeInfo;
	}

	@Override
	public void writeSheet() throws Exception {
		writeTdhVersion();
		writeOSAndJdkVersion();
		setColumSize();
	}
	
	private void writeTdhVersion() throws Exception {
		sheet.addCell(new Label(0, 1, "集群版本号", CELL_BOLD));
		sheet.addCell(new Label(1, 1, GlobalArgs.version, CELL_THIN));
	}
	
	private void writeOSAndJdkVersion() throws Exception {
		int row = 3;
		sheet.addCell(new Label(0, row, "hostname", CELL_BOLD));
		sheet.addCell(new Label(1, row, "OSType", CELL_BOLD));
		sheet.addCell(new Label(2, row, "jdk version", CELL_BOLD));
		
		for (Entry<String, NodeBean> entry : nodeInfo.getNodes().entrySet()) {
			NodeBean node = entry.getValue();
			String osType = node.getParamFromShell("OSType");
			if (osType == null) {
				osType = "";
			}
			String jdkVersion = node.getParamFromShell("jdk_version");
			if (jdkVersion == null) {
				jdkVersion = "";
			}
			row += 1;
			sheet.addCell(new Label(0, row, node.getHostName(), CELL_THIN));
			sheet.addCell(new Label(1, row, osType.replaceAll("\n", " ").trim(), CELL_THIN));
			sheet.addCell(new Label(2, row, jdkVersion.replaceAll("\n", " ").trim(), CELL_THIN));
		}
	}
	
	private void setColumSize() throws Exception {
		sheet.setColumnView(0, 20);
		sheet.setColumnView(1, 50);
		sheet.setColumnView(2, 50);
	}
}
