package io.transwarp.cluster.servlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.InspectionData;
import io.transwarp.inspection.CheckItemEnum;


public abstract class AbstractGetInfo {

	protected final Logger log = LoggerFactory.getLogger(AbstractGetInfo.class);
	protected final InspectionData data;
	protected final Method method;
	
	public AbstractGetInfo(final Method method,
			final InspectionData data) {
		this.method = method;
		this.data = data;
	}
	
	public void check() throws Exception {
		getInfo();
		GlobalArgs.timeStatisticses.get(CheckItemEnum.CLUSTER.name()).setEndTime();
	}
	
	public abstract void getInfo() throws Exception ;
}
