package io.transwarp.cluster.servlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.InspectionData;
import io.transwarp.inspection.CheckInterface;

public class ClusterCheck implements CheckInterface {

	private final Logger log = LoggerFactory.getLogger(ClusterCheck.class);
	private final Method method;
	private final InspectionData data;
	
	public ClusterCheck(final InspectionData data) {
		StringBuffer loginInfo = new StringBuffer();
		loginInfo.append("+---------------------------------------")
			.append("\n| mangerIP : ").append(data.getManagerIP())
			.append("\n| managerPort : ").append(data.getManagerPort())
			.append("\n| username : ").append(data.getUsername())
			.append("\n| password : ").append(data.getPassword())
			.append("\n+---------------------------------------");
		System.out.println(loginInfo.toString());
		this.method = Method.custom()
				.setManagerIP(data.getManagerIP())
				.setPort(data.getManagerPort())
				.setUsername(data.getUsername())
				.setPassword(data.getPassword())
				.setProperty(data.prop_restapi)
				.build();
		this.data = data;
	}
	
	@Override
	public void check() throws Exception {
		AbstractGetInfo getInfo = null;
		for (checkItem item : checkItem.values()) {
			try {
				getInfo = this.buildCheckItem(item);
				getInfo.check();
			} catch (Exception e) {
				String errorMessage = String.format("get info by rest api of [%s] is faild | %s", item.name(), e.getMessage());
				GlobalArgs.ERROR_INFO.add(errorMessage);
				log.error(errorMessage);
				e.printStackTrace();
			}
		}
		method.close();
	}
	
	private enum checkItem {
		VERSION,
		LICENSE,
		SERVICE,
		NODE,
		METRIC,
		ALERT,
		SID
	}
	
	private AbstractGetInfo buildCheckItem(checkItem item) {
		switch(item) {
		case VERSION : return new GetInfoOfVersion(method, data);
		case LICENSE : return new GetInfoOfLicense(method, data);
		case SERVICE : return new GetInfoOfService(method, data);
		case NODE    : return new GetInfoOfNode(method, data);
		case METRIC  : return new GetInfoOfMetric(method, data);
		case ALERT   : return new GetInfoOfAlerts(method, data);
		case SID     : return new GetInfoOfServiceSid(data);
		default : throw new RuntimeException("no find this check item : " + item.name());
		}
	}
}
