package io.transwarp.cluster.servlet;

import java.util.Locale;

import net.sf.json.JSONArray;
import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.AlertBean;
import io.transwarp.common.bean.InspectionData;

public class GetInfoOfAlerts extends AbstractGetInfo {

	public GetInfoOfAlerts(final Method method,
			final InspectionData data) {
		super(method, data);
	}
	
	@Override
	public void getInfo() throws Exception {
		log.info("begin get alerts of cluster by rest api");
		String url = data.prop_restapi.getProperty("alert.url", "/alerts");
		String httpMethod = data.prop_restapi.getProperty("alert.method", "get");
		
		String status = GlobalArgs.prop_rules.getProperty("cluster.alert.status", "ACTIVE");
		if (!status.equals("")) {
			status = status.toUpperCase(Locale.getDefault());
			url = String.format("%s?status=%s", url, status);
		}
		String result = method.exec(url, httpMethod, "");
		
		JSONArray array = JSONArray.fromObject(result);
		int number = array.size();
		for (int i = 0; i < number; i++) {
			String json = array.getString(i);
			AlertBean alert = new AlertBean(json);
			data.clusterInfo.addAlertBean(alert);
		}
	}

}
