package io.transwarp.cluster.servlet;

import io.transwarp.common.bean.InspectionData;

public class GetInfoOfLicense extends AbstractGetInfo {

	public GetInfoOfLicense(final Method method,
			final InspectionData data) {
		super(method, data);
	}
	
	@Override
	public void getInfo() throws Exception {
		log.info("get cluster license info by rest api");

		String url = data.prop_restapi.getProperty("license.url", "/manager/license");
		String httpMethod = data.prop_restapi.getProperty("license.method", "get");
		
		String result = method.exec(url, httpMethod, "");
		if (result == null) {
			throw new Exception("cluster license info is null");
		}
			
		data.clusterInfo.addLicense(result);		
	}
}
