package io.transwarp.cluster.servlet;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.InspectionData;
import io.transwarp.common.bean.node.MetricBean;
import io.transwarp.common.bean.node.NodeBean;

import java.util.List;
import java.util.Map.Entry;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.dom4j.Element;

public class GetInfoOfMetric extends AbstractGetInfo {
	
	private static Long HourTime = 60 * 60 * 1000L;

	public GetInfoOfMetric(final Method method,
			final InspectionData data) {
		super(method, data);
	}
	
	@Override
	public void getInfo() throws Exception {
		String url = data.prop_restapi.getProperty("metric.url", "/nodes/%s/metric?metricnames=%s&start=%s&end=%s");
		String httpMethod = data.prop_restapi.getProperty("metric.method", "get");
		Long startTime = System.currentTimeMillis() - 24 * HourTime;
		for (Entry<String, NodeBean> entry : data.nodeInfo.getNodes().entrySet()) {
			NodeBean node = entry.getValue();
			String nodeId = node.getId();
			log.info("get metric of [{}] by rest api", node.getHostName());
			List<Element> items = data.prop_metric.getAll();
			for (Element item : items) {
				String metricNameCN = item.elementText("name");
				String metricNameEN = item.elementText("value");
//				MetricBean metricInDetail = getMetric(nodeId, url, httpMethod, metricNameEN, startTime, HourTime, 24);
				MetricBean metricOneDay = getMetric(nodeId, url, httpMethod, metricNameEN, startTime, 24*HourTime, 1);
//				node.addMetricInDetail(metricNameCN, metricInDetail);
				node.addMetricOneDay(metricNameCN, metricOneDay);
			}
		}
	}
	
	private MetricBean getMetric(final String nodeId,
			final String url,
			final String httpMethod,
			final String metricNameEN,
			final Long startTime,
			final Long diffTime,
			final int count) {
		MetricBean metric = new MetricBean();
		metric.setMetricName(metricNameEN);
		Long start = startTime;
		for (int i = 0; i < count; i++) {
			Long endTime = startTime + diffTime;
			String execUrl = String.format(url, nodeId, metricNameEN, start, endTime);
			String result = method.exec(execUrl, httpMethod, "");
			analysisResult(metric, result);
			start = endTime;
		}
		return metric;
	}
	
	private void analysisResult(MetricBean metric, String result) {
		JSONArray array = JSONArray.fromObject(result);
		for (int i = 0; i < array.size(); i++) {
			JSONObject item = array.getJSONObject(i);
			String unit = item.getString("unit");
			Long timeStamp = item.getLong("timestamp");
			String value = "";
			if (GlobalArgs.version.startsWith("4")) {
				value = item.getJSONObject("metricValue").getString("value");
			} else {
				value = item.getString("value");
			}
			metric.setUnit(unit);
			metric.addMetricValues(timeStamp, value);
		}
	}
	
}
