package io.transwarp.cluster.servlet;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.common.bean.node.NodeBean;
import net.sf.json.JSONArray;

public class GetInfoOfNode extends AbstractGetInfo {

	public GetInfoOfNode(final Method method,
			final InspectionData data) {
		super(method, data);
	}
	
	@Override
	public void getInfo() throws Exception {
		log.info("begin get cluster node info by rest api");
		String url = data.prop_restapi.getProperty("node.url", "/nodes");
		String httpMethod = data.prop_restapi.getProperty("node.method", "get");
		
		String result = method.exec(url, httpMethod, "");
		
		JSONArray array = JSONArray.fromObject(result);
		for (int i = 0; i < array.size(); i++) {
			String json = array.getString(i);
			NodeBean node = new NodeBean(json);
			data.nodeInfo.addNodeBean(node.getHostName(), node);
		}
	}
}
