package io.transwarp.cluster.servlet;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.common.bean.service.RoleBean;
import io.transwarp.common.bean.service.ServiceBean;
import net.sf.json.JSONArray;

public class GetInfoOfService extends AbstractGetInfo {

	public GetInfoOfService(final Method method,
			final InspectionData data) {
		super(method, data);
	}
	
	@Override
	public void getInfo() throws Exception {
		log.info("get cluster service info by rest api");
		
		String urlOfService = data.prop_restapi.getProperty("service.url", "/services");
		String urlOfRole = data.prop_restapi.getProperty("service.role.url", "/serviceRoles?serviceId=%s");
		String httpMethodOfService = data.prop_restapi.getProperty("service.method", "get");
		String httpMethodOfRole = data.prop_restapi.getProperty("service.role.method", "get");
		
		String result = method.exec(urlOfService, httpMethodOfService, "");
		
		JSONArray array = JSONArray.fromObject(result);
		for (int i = 0; i < array.size(); i++) {
			try {
				String json = array.getString(i);
				ServiceBean service = new ServiceBean(json);
				getRoleOfService(service, String.format(urlOfRole, service.getId()), httpMethodOfRole);
				data.clusterInfo.addServiceBean(service.getName(), service);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	private void getRoleOfService(final ServiceBean service,
			final String url,
			final String httpMethod) {
		
		String result = method.exec(url, httpMethod, "");
		
		JSONArray array = JSONArray.fromObject(result);
		for (int i = 0; i < array.size(); i++) {
			String json = array.getString(i);
			RoleBean role = new RoleBean(json);
			service.addRole(role);
		}
	}
}
