package io.transwarp.cluster.servlet;

import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.InspectionData;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.common.util.UtilTools;

public class GetInfoOfServiceSid extends AbstractGetInfo {

	private final Map<String, ServiceBean> services;
	
	public GetInfoOfServiceSid(final InspectionData data) {
		super(null, data);
		services = data.clusterInfo.getServices();
	}
	
	@Override
	public void getInfo() throws Exception {
		if (GlobalArgs.version.startsWith("4")) {
			checkServiceMapV4x();
		}
	}
	
	private void checkServiceMapV4x() throws Exception {
		log.info("get service sid of TDH 4.x from json file service.json");
		String result = UtilTools.readFile(data.clusterInfo.getSidPath());
		JSONArray array = JSONArray.fromObject(result);
		for (int i = 0; i < array.size(); i++) {
			JSONObject json = array.getJSONObject(i);
			Object activeStatus = json.get("activeStatus");
			if (activeStatus == null || "deleted".equalsIgnoreCase(activeStatus.toString())) {
				continue;
			}
			try {
				String name = json.getString("name");
				String sid = json.getString("sid");
				ServiceBean service = services.get(name);
				if (service == null) {
					log.error("no find service : {}", name);
					continue;
				}
				service.setSid(sid);
			} catch (Exception e) {
				log.error("get service sid of TDH 4.x faild, error message is : {}", e.getMessage());
				continue;
			}
		}
	}
	
	
}
