package io.transwarp.cluster.servlet;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.InspectionData;
import net.sf.json.JSONObject;

public class GetInfoOfVersion extends AbstractGetInfo {

	public GetInfoOfVersion(final Method method,
			final InspectionData data) {
		super(method, data);
	}
	
	@Override
	public void getInfo() throws Exception {
		log.info("get cluster version info by rest api");
		
		String url = data.prop_restapi.getProperty("version.url", "/manager/version");
		String httpMethod = data.prop_restapi.getProperty("version.method", "get");
		
		String result = method.exec(url, httpMethod, "");
		
		if (result == null) {
			throw new Exception("cluster version info is null");
		}
		
		JSONObject json = JSONObject.fromObject(result);
		GlobalArgs.version = json.getString("version");
		log.info("this cluster verison is [{}]", GlobalArgs.version);
	}
}
