package io.transwarp.cluster.servlet;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.ReadXmlUtil;

import java.io.IOException;
import java.net.URI;

import net.sf.json.JSONException;
import net.sf.json.JSONObject;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Method {

	private static Logger log = LoggerFactory.getLogger(Method.class);

	private final String urlHead;
	private final CloseableHttpClient client;
	private final ReadXmlUtil prop_restapi;
	private CloseableHttpResponse response;
	
	Method(final String urlHead,
			final String username,
			final String password,
			final ReadXmlUtil prop_restapi) {
		this.urlHead = urlHead;
		this.client = HttpClients.createDefault();
		this.prop_restapi = prop_restapi;
		login(username, password);
	}
	
	private void login(final String username, 
			final String password) {
		JSONObject param = new JSONObject();
		param.put("userName", username);
		param.put("userPassword", password);
		String url = prop_restapi.getProperty("login.url", "/users/login");
		String httpMethod = prop_restapi.getProperty("login.method", "post");
		
		String result = this.exec(url, httpMethod, param.toString());
		try {
			JSONObject json = JSONObject.fromObject(result);
			Object messageKey = json.get("messageKey");
			if (messageKey == null) {
				return ;
			} else {
				throw new Exception("login faild, " + json.getString("message"));
			}
		} catch (JSONException e) {
			log.error(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void close() {
		String url = prop_restapi.getProperty("logout.url", "/users/logout");
		String httpMethod;
		if (GlobalArgs.version.startsWith("4")) {
			httpMethod = prop_restapi.getProperty("logout.4x.method", "get");
		} else {
			httpMethod = prop_restapi.getProperty("logout.5x.method", "post");
		}
		
		String result = this.exec(url, httpMethod, "");
		if (!result.equals("{}") && !result.equals("success")) {
			log.error("rest api logout faild, result : " + result);
			throw new RuntimeException("logout faild");
		}
	}
	
	public String exec(final String url, final String httpMethod, final String param) {
		String responseResult = "";
		HttpEntity entity = null;
		try {
			if (httpMethod.equalsIgnoreCase("get")) {
				entity = getMethod(this.urlHead + url);
			} else if (httpMethod.equalsIgnoreCase("post")) {
				entity = postMethod(this.urlHead + url, param);
			} else if (httpMethod.equalsIgnoreCase("put")) {
				entity = putMethod(this.urlHead + url, param);
			} else if (httpMethod.equalsIgnoreCase("delete")) {
				entity = deleteMethod(this.urlHead + url, param);
			} else {
				throw new RuntimeException("no find this http method : [" + httpMethod + "]");
			}
			responseResult = EntityUtils.toString(entity);
		} catch (Exception e) {
			log.error(e.getMessage());
			e.printStackTrace();
		} finally {
			try {
				response.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return responseResult;
	}
	
	private HttpEntity getMethod(final String url) throws Exception {
		HttpGet httpget = new HttpGet(url);
		response = client.execute(httpget);
		return response.getEntity();
	}
	
	private HttpEntity postMethod(final String url, final String param) throws Exception {
		HttpPost httppost = new HttpPost(url);
		if (!param.equals("")) {
			StringEntity entity = new StringEntity(param);
			httppost.setEntity(entity);
		}
		response = client.execute(httppost);
		return response.getEntity();
	}
	
	private HttpEntity putMethod(final String url, final String param) throws Exception {
		HttpPut httpput = new HttpPut(url);
		if (!param.equals("")) {
			StringEntity entity = new StringEntity(param);
			httpput.setEntity(entity);
		}
		response = client.execute(httpput);
		return response.getEntity();
	}
	
	private HttpEntity deleteMethod(final String url, final String param) throws Exception {
		HttpDeleteWithBody httpdelete = new HttpDeleteWithBody(url);
		if (!param.equals("")){ 
			StringEntity entity = new StringEntity(param);
			httpdelete.setEntity(entity);
		}
		response = client.execute(httpdelete);
		return response.getEntity();
	}
	
	private class HttpDeleteWithBody extends HttpEntityEnclosingRequestBase {
		public static final String METHOD_NAME = "DELETE";
		public String getMethod() {
			return METHOD_NAME;
		}
		public HttpDeleteWithBody(final String uri) {
			super();
			setURI(URI.create(uri));
		}
		@SuppressWarnings("unused")
		public HttpDeleteWithBody() {
			super();
		}
	}
	
	public static Method.Build custom() {
		return new Build();
	}
	
	public static class Build {
		private String managerIP;
		private String port;
		private String username;
		private String password;
		private ReadXmlUtil prop_restapi;
		
		Build() {
			this.managerIP = "";
			this.port = "8180";
			this.username = "";
			this.password = "";
		}
		
		public Method build() {
			return new Method(String.format("http://%s:%s/api", this.managerIP, this.port), 
					this.username,
					this.password,
					this.prop_restapi);
		}
		
		public Build setManagerIP(Object managerIP) {
			this.managerIP = managerIP == null ? "" : managerIP.toString();
			return this;
		}
		
		public Build setPort(Object port) {
			this.port = port == null ? "" : port.toString();
			return this;
		}
		
		public Build setUsername(Object username) {
			this.username = username == null ? "" : username.toString();
			return this;
		}
		
		public Build setPassword(Object password) {
			this.password = password == null ? "" : password.toString();
			return this;
		}
		
		public Build setProperty(ReadXmlUtil prop_restapi) {
			this.prop_restapi = prop_restapi;
			return this;
		}
	}
}
