package io.transwarp.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class MyProperty extends Properties {

	private static final long serialVersionUID = 1L;

	@Override
	public String getProperty(String key, String defaultValue) {
		String value = getProperty(key);
		if (value == null || value.trim().equals("")) {
			value = defaultValue;
		}
		return value.trim();
	}
	
	public void load(final String path) {
		File file = new File(path);
		if (!file.exists()) {
			throw new RuntimeException(String.format("no find this file : [%s]", path));
		}
		try {
			super.load(new FileInputStream(file));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
