package io.transwarp.common;

import java.io.File;
import java.util.List;
import java.util.Vector;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ReadXmlUtil {

	private Vector<Element> elements;
	
	public ReadXmlUtil() {
		super();
		this.elements = new Vector<Element>();
	}
	
	public void load(String path) {
		File file = new File(path);
		if (!file.exists()) {
			throw new RuntimeException("no find this xml file " + path);
		}
		try {
			Document document = new SAXReader().read(file);
			Element rootElement = document.getRootElement();
			getChildElements(rootElement);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public String getProperty(String key, String defaultValue) {
		for (Element element : elements) {
			String name = element.elementText("name");
			if (name.equals(key)) {
				return element.elementText("value");
			}
		}
		return defaultValue;
	}
	
	public Element getElementConfig(String key, String value) {
		for (Element config : elements) {
			String configValue = config.elementText(key);
			if (value.equals(configValue)) {
				return config;
			}
		}
		return null;
	}
	
	private void getChildElements(Element rootElement) {
		List<?> children = rootElement.elements();
		for (Object element : children) {
			elements.add((Element)element);
		}
	}
	
	/*public Element getElementByKeyValue(String key, String value) {
		for (Element element : elements) {
			String elementValue = element.elementText(key);
			if (elementValue != null && elementValue.equals(value)) {
				return element;
			}
		}
		log.warn("no find key : [{}], value : [{}]", key, value);
		return null;
	}*/
	
	public List<Element> getAll() {
		return elements;
	}
}
