package io.transwarp.common;


public class TimeStatistics {
	
	private final static String[] UNIT = new String[]{"second", "minute", "hour"};
	private Long startTime;
	private Long endTime;
	
	public TimeStatistics() {
		startTime = System.currentTimeMillis();
		endTime = startTime;
	}
	
	public void setEndTime() {
		synchronized (this.endTime) {
			this.endTime = System.currentTimeMillis();
		}
	}
	
	public String getCostTime() {
		Double costTime = (endTime - startTime)/1000.0;
		int id = 0;
		while (id < 3 && costTime > 60) {
			costTime /= 60;
			id += 1;
		}
		return String.format("%.2f %s", costTime, UNIT[id]);
	}
}
