package io.transwarp.common.bean;

import net.sf.json.JSONObject;

public class AlertBean {

	private String timeStamp;
	private String description;
	private String contextName;
	private String contextType;
	private String needManuallyClear;
	private String id;
	private String status;
	private String category;
	private String severity;
	private String title;
	private String subId;
	private String contextId;
	
	public AlertBean(final String json) {
		this(JSONObject.fromObject(json));
	}
	
	public AlertBean(final JSONObject json) {
		this.setTimeStamp(json.get("timestamp"));
		this.setDescription(json.get("description"));
		this.setContextName(json.get("contextName"));
		this.setContextType(json.get("contextType"));
		this.setNeedManuallyClear(json.get("needManuallyClear"));
		this.setId(json.get("id"));
		this.setStatus(json.get("status"));
		this.setCategory(json.get("category"));
		this.setSeverity(json.get("severity"));
		this.setTitle(json.get("title"));
		this.setSubId(json.get("subId"));
		this.setContextId(json.get("contextId"));
	}
	
	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("id : ").append(this.id).append("\n")
			.append("subId").append(this.subId).append("\n")
			.append("contextId").append(this.contextId).append("\n")
			.append("contextName : ").append(this.contextName).append("\n")
			.append("contextType : ").append(this.contextType).append("\n")
			.append("timeStamp : ").append(this.timeStamp).append("\n")
			.append("status : ").append(this.status).append("\n")
			.append("title : ").append(this.title).append("\n")
			.append("severity : ").append(this.severity).append("\n")
			.append("category : ").append(this.category).append("\n")
			.append("needManuallyClear").append(this.needManuallyClear).append("\n")
			.append("description : ").append(this.description).append("\n");
		return buffer.toString();
	}
	
	public void setTimeStamp(Object timeStamp) {
		this.timeStamp = timeStamp == null ? "" : timeStamp.toString();
	}
	
	public void setDescription(Object description) {
		this.description = description == null ? "" : description.toString();
	}
	
	public void setContextName(Object contextName) {
		this.contextName = contextName == null ? "" : contextName.toString();
	}
	
	public void setContextType(Object contextType) {
		this.contextType = contextType == null ? "" : contextType.toString();
	}
	
	public void setNeedManuallyClear(Object needManuallyClear) {
		this.needManuallyClear = needManuallyClear == null ? "" : needManuallyClear.toString();
	}
	
	public void setId(Object id) {
		this.id = id == null ? "" : id.toString();
	}
	
	public void setStatus(Object status) {
		this.status = status == null ? "" : status.toString();
	}
	
	public void setCategory(Object category) {
		this.category = category == null ? "" : category.toString();
	}
	
	public void setSeverity(Object severity) {
		this.severity = severity == null ? "" : severity.toString();
	}
	
	public void setTitle(Object title) {
		this.title = title == null ? "" : title.toString();
	
	}
	
	public void setSubId(Object subId) {
		this.subId = subId == null ? "" : subId.toString();
	}
	
	public void setContextId(Object contextId) {
		this.contextId = contextId == null ? "" : contextId.toString();
	}

	public String getTimeStamp() {
		return timeStamp;
	}

	public String getDescription() {
		return description;
	}

	public String getContextName() {
		return contextName;
	}

	public String getContextType() {
		return contextType;
	}

	public String getNeedManuallyClear() {
		return needManuallyClear;
	}

	public String getId() {
		return id;
	}

	public String getStatus() {
		return status;
	}

	public String getCategory() {
		return category;
	}

	public String getSeverity() {
		return severity;
	}

	public String getTitle() {
		return title;
	}

	public String getSubId() {
		return subId;
	}

	public String getContextId() {
		return contextId;
	}
	
	
}
