package io.transwarp.common.bean;

import io.transwarp.common.MyProperty;
import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.bean.service.KafkaTopicBean;
import io.transwarp.common.bean.service.ServiceBean;

import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

import net.sf.json.JSONObject;

/**
 * 集群信息存储
 * @author xhy
 */
public class ClusterInfo {

	private final Map<String, ServiceBean> services;
	private final Map<String, Map<String, KafkaTopicBean>> kafkaTopicMaps;
	private final Vector<AlertBean> alerts;
	private final Map<String, String> hdfsMetaDatas;
	private final Vector<JSONObject> hdfsSpace;
	private final LicenseBean license;
	
	public final MyProperty prop_config_name;
	public final ReadXmlUtil prop_process_check;
	public final ReadXmlUtil prop_service_check;
	public final ReadXmlUtil prop_hdfs_check;
	
	private String sidPath;
	
	public ClusterInfo() {
		services = new ConcurrentHashMap<String, ServiceBean>();
		kafkaTopicMaps = new ConcurrentHashMap<String, Map<String, KafkaTopicBean>>();
		alerts = new Vector<AlertBean>();
		
		license = new LicenseBean();
		hdfsMetaDatas = new ConcurrentHashMap<String, String>();
		hdfsSpace = new Vector<JSONObject>();
		
		prop_config_name = new MyProperty();
		prop_process_check = new ReadXmlUtil();
		prop_service_check = new ReadXmlUtil();
		prop_hdfs_check = new ReadXmlUtil();
	}
	
	public void loadPropertyFile(final String path_configName,
			final String path_process,
			final String path_service,
			final String path_hdfs) {
		prop_config_name.load(path_configName);
		prop_process_check.load(path_process);
		prop_service_check.load(path_service);
		prop_hdfs_check.load(path_hdfs);
	}
	
	public void addServiceBean(final String servicename, final ServiceBean service) {
		services.put(servicename, service);
	}
	
	public void addKafkaTopicBean(final String servicename, final Map<String, KafkaTopicBean> topics) {
		kafkaTopicMaps.put(servicename, topics);
	}
	
	public void addAlertBean(final AlertBean alert) {
		alerts.add(alert);
	}
	
	public void addLicense(final String jsonString) {
		license.addLicenseInfo(jsonString);
	}
	
	public void addHdfsMetaData(final String checkName, final String result) {
		hdfsMetaDatas.put(checkName, result);
	}
	
	public void addHdfsSpace(final JSONObject json) {
		hdfsSpace.add(json);
	}
	
	public void setSidPath(final String sidPath) {
		this.sidPath = sidPath;
	}
	
	public String getSidPath() {
		return sidPath;
	}
	
	public Map<String, ServiceBean> getServices() {
		return services;
	}

	public Map<String, Map<String, KafkaTopicBean>> getKafkaTopicMaps() {
		return kafkaTopicMaps;
	}

	public Vector<AlertBean> getAlerts() {
		return alerts;
	}

	public Map<String, String> getHdfsMetaDatas() {
		return hdfsMetaDatas;
	}

	public Vector<JSONObject> getHdfsSpace() {
		return hdfsSpace;
	}

	public LicenseBean getLicense() {
		return license;
	}
}
