package io.transwarp.common.bean;

import io.transwarp.common.ReadXmlUtil;

public class InspectionData {

	public final ClusterInfo clusterInfo;
	public final NodeInfo nodeInfo;
	public final TableInfo tableInfo;
	
	public final ReadXmlUtil prop_restapi;
	public final ReadXmlUtil prop_metric;
	
	private String managerIP;
	private String username;
	private String password;
	private String managerPort;
	
	public InspectionData() {
		clusterInfo = new ClusterInfo();
		nodeInfo = new NodeInfo();
		tableInfo = new TableInfo();
		
		prop_restapi = new ReadXmlUtil();
		prop_metric = new ReadXmlUtil();
	}
	
	public void loadPropertyFile(final String path_restapi,
			final String path_metric) {
		prop_restapi.load(path_restapi);
		prop_metric.load(path_metric);
	}

	public String getManagerIP() {
		return managerIP;
	}

	public void setManagerIP(String managerIP) {
		this.managerIP = managerIP;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getManagerPort() {
		return managerPort;
	}

	public void setManagerPort(String managerPort) {
		this.managerPort = managerPort;
	}
	
}
