package io.transwarp.common.bean;

import java.util.ArrayList;
import java.util.List;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class LicenseBean {

	private String clusterSize;
	private String supportStartDay;
	private String serverKey;
	private String serialNumber;
	private List<ComponentBean> components;
	
	public void addLicenseInfo(String jsonString) {
		JSONObject json = JSONObject.fromObject(jsonString);
		this.components = new ArrayList<ComponentBean>();
		this.setClusterSize(json.get("clusterSize"));
		this.setSupportStartDay(json.get("supportStartDay"));
		this.setServerKey(json.get("serverKey"));
		this.setSerialNumber(json.get("serialNumber"));
		JSONArray array = json.getJSONArray("components");
		int number = array.size();
		for (int i = 0; i < number; i++) {
			this.addComponent(new ComponentBean(array.getJSONObject(i)));
		}
	}
	
	public void setClusterSize(Object clusterSize) {
		this.clusterSize = clusterSize == null ? "" : clusterSize.toString();
	}
	
	public void setSupportStartDay(Object supportStartDay) {
		this.supportStartDay = supportStartDay == null ? "" : supportStartDay.toString();
	}
	
	public void setServerKey(Object serverKey) {
		this.serverKey = serverKey == null ? "" : serverKey.toString();
	}
	
	public void setSerialNumber(Object serialNumber) {
		this.serialNumber = serialNumber == null ? "" : serialNumber.toString();
	}
	
	public void addComponent(ComponentBean component) {
		this.components.add(component);
	}
	
	public String getClusterSize() {
		return clusterSize;
	}

	public String getSupportStartDay() {
		return supportStartDay;
	}

	public String getServerKey() {
		return serverKey;
	}

	public String getSerialNumber() {
		return serialNumber;
	}

	public List<ComponentBean> getComponents() {
		return components;
	}

	public class ComponentBean {
		
		private String compType;
		private String compTypeFriendly;
		private String compSize;
		private String licenseType;
		private String expiredDate;
		private String supportExpiration;
		
		public ComponentBean(String json) {
			this(JSONObject.fromObject(json));
		}
		
		public ComponentBean(JSONObject json) {
			this.setCompType(json.get("compType"));
			this.setCompTypeFriendly(json.get("compTypeFriendly"));
			this.setCompSize(json.get("compSize"));
			this.setLicenseType(json.get("licenseType"));
			this.setExpiredDate(json.get("expiredDate"));
			this.setSupportExpiration(json.get("supportExpiration"));
		}
		
		public void setCompType(Object compType) {
			this.compType = compType == null ? "" : compType.toString();
		}
		
		public void setCompTypeFriendly(Object compTypeFriendly) {
			this.compTypeFriendly = compTypeFriendly == null ? "" : compTypeFriendly.toString();
		}
		
		public void setCompSize(Object compSize) {
			this.compSize = compSize == null ? "" : compSize.toString();
		}
		
		public void setLicenseType(Object licenseType) {
			this.licenseType = licenseType == null ? "" : licenseType.toString();
		}
		
		public void setExpiredDate(Object expiredDate) {
			this.expiredDate = expiredDate == null ? "" : expiredDate.toString();
		}
		
		public void setSupportExpiration(Object supportExpiration) {
			this.supportExpiration = supportExpiration == null ? "" : supportExpiration.toString();
		}

		public String getCompType() {
			return compType;
		}

		public String getCompTypeFriendly() {
			return compTypeFriendly;
		}

		public String getCompSize() {
			return compSize;
		}

		public String getLicenseType() {
			return licenseType;
		}

		public String getExpiredDate() {
			return expiredDate;
		}

		public String getSupportExpiration() {
			return supportExpiration;
		}
		
		
	}
}
