package io.transwarp.common.bean;

import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.bean.node.NodeBean;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NodeInfo {

	private final Map<String, NodeBean> nodes;
	
	public final ReadXmlUtil prop_node_check;
	public final ReadXmlUtil prop_port_check;
	
	private Integer port;
	
	public NodeInfo() {
		nodes = new ConcurrentHashMap<String, NodeBean>();
		prop_node_check = new ReadXmlUtil();
		prop_port_check = new ReadXmlUtil();
	}
	
	public void loadPropertyFile(final String path_node, final String path_port) {
		prop_node_check.load(path_node);
		prop_port_check.load(path_port);
	}
	
	public void addNodeBean(final String hostname, final NodeBean node) {
		nodes.put(hostname, node);
	}

	public Map<String, NodeBean> getNodes() {
		return nodes;
	}

	public Integer getPort() {
		return port;
	}

	public void setPort(Integer port) {
		this.port = port;
	}
	
}
