package io.transwarp.common.bean;

import java.util.Locale;

public class OutputSelectBean {

	private boolean nodeCheck;
	private boolean hdfsCheck;
	private boolean hdfsInfo;
	private boolean hdfsSpace;
	private boolean processCheck;
	private boolean tableCheck;
	private boolean textCheck;
	private boolean orcCheck;
	private boolean hbaseCheck;
	private boolean holodeskCheck;
	private boolean esCheck;
	private boolean serviceCheck_es;
	private boolean serviceCheck_kafka;
	
	public OutputSelectBean(final String[] items) {
		init();
		for (String item : items) {
			item = item.toLowerCase(Locale.getDefault());
			if (item.equals("nodeinfo") || item.equals("disk")) {
				nodeCheck = true;
			} else if (item.equals("hdfsinfo")) {
				hdfsInfo = true;
			} else if (item.equals("hdfsspace")) {
				hdfsSpace = true;
			} else if (item.equals("process")) {
				processCheck = true;
			} else if (item.equals("ddl_text")) {
				textCheck = true;
			} else if (item.equals("ddl_orc")) {
				orcCheck = true;
			} else if (item.equals("ddl_hbase")) {
				hbaseCheck = true;
			} else if (item.equals("ddl_holodesk")) {
				holodeskCheck = true;
			} else if (item.equals("ddl_es")) {
				esCheck = true;
			} else if (item.equals("servicecheck_es")) {
				serviceCheck_es = true;
			} else if (item.equals("servicecheck_kafka")) {
				serviceCheck_kafka = true;
			}
		}
		if (isTextCheck() || isOrcCheck() || isHbaseCheck() || isHolodeskCheck() || isEsCheck() || isServiceCheckEs()) {
			tableCheck = true;
		}
		if (isTableCheck() || isHdfsInfo() || isHdfsSpace()) {
			hdfsCheck = true;
		}
	}
	
	private void init() {
		nodeCheck = false;
		hdfsCheck = false;
		hdfsInfo = false;
		hdfsSpace = false;
		processCheck = false;
		tableCheck = false;
		textCheck = false;
		orcCheck = false;
		hbaseCheck = false;
		holodeskCheck = false;
		esCheck = false;
		serviceCheck_es = false;
		serviceCheck_kafka = false;
	}

	public boolean isNodeCheck() {
		return nodeCheck;
	}

	public boolean isHdfsCheck() {
		return hdfsCheck;
	}

	public boolean isHdfsInfo() {
		return hdfsInfo;
	}

	public boolean isHdfsSpace() {
		return hdfsSpace;
	}

	public boolean isProcessCheck() {
		return processCheck;
	}

	public boolean isTextCheck() {
		return textCheck;
	}

	public boolean isTableCheck() {
		return tableCheck;
	}

	public boolean isOrcCheck() {
		return orcCheck;
	}

	public boolean isHbaseCheck() {
		return hbaseCheck;
	}

	public boolean isHolodeskCheck() {
		return holodeskCheck;
	}

	public boolean isEsCheck() {
		return esCheck;
	}

	public boolean isServiceCheckEs() {
		return serviceCheck_es;
	}
	
	public boolean isServiceCheckKafka() {
		return serviceCheck_kafka;
	}

}
