package io.transwarp.common.bean;

import io.transwarp.common.bean.service.KafkaTopicBean;
import io.transwarp.common.bean.service.ProcessBean;

import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

import net.sf.json.JSONObject;

public final class ServiceParameterInfo {

	private final Map<String, ProcessBean> processInfos;
	private final Map<String, String> nnMetadatas;
	private final Map<String, JSONObject> loginInfoOfServices;
	private final Map<String, Map<String, KafkaTopicBean>> topicInfos;
	private final Vector<String> configCheckCompleted;
	
	private final String nodeUser;
	
	
	public ServiceParameterInfo(final String nodeUser) {
		this.processInfos = new ConcurrentHashMap<String, ProcessBean>();
		this.nnMetadatas = new ConcurrentHashMap<String, String>();
		this.loginInfoOfServices = new ConcurrentHashMap<String, JSONObject>();
		this.topicInfos = new ConcurrentHashMap<String, Map<String, KafkaTopicBean>>();
		this.configCheckCompleted = new Vector<String>();
		this.nodeUser = nodeUser;
	}
	
	public synchronized void addConfigCheckCompletedService(final String servicename) {
		this.configCheckCompleted.add(servicename);
	}
	
	public synchronized boolean isConfigCheckCompleted(final String servicename) {
		int id = this.configCheckCompleted.indexOf(servicename);
		if (id == -1) {
			return false;
		} else {
			return true;
		}
	}
	
	public synchronized void addLoginInfoOfServices(final String servicename, final JSONObject json) {
		this.loginInfoOfServices.put(servicename, json);
	}
	
	public synchronized void addProcessInfo(final String servicename, final ProcessBean process) {
		this.processInfos.put(servicename, process);		
	}
	
	public synchronized void addTopicInfos(final String zookeeperName, final Map<String, KafkaTopicBean> topicInfo) {
		this.topicInfos.put(zookeeperName, topicInfo);
	}
	
	public Map<String, ProcessBean> getProcessInfos() {
		return this.processInfos;
	}
	
	public Map<String, String> getNnMetadatas() {
		return this.nnMetadatas;
	}
	
	public Map<String, JSONObject> getLoginInfoOfServices() {
		return this.loginInfoOfServices;
	}
	
	public Map<String, Map<String, KafkaTopicBean>> getTopicInfos() {
		return this.topicInfos;
	}
	
	public JSONObject getLoginInfoOfService(String servicename) {
		return this.loginInfoOfServices.get(servicename);
	}
	
	public String getNodeUser() {
		return this.nodeUser;
	}
}
