package io.transwarp.common.bean;

import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.bean.table.*;

public class TableInfo {

	public final AllOrcTables TABLE_ORC = new AllOrcTables();
	public final AllHbaseTables TABLE_HBASE = new AllHbaseTables();
	public final AllHolodeskTables TABLE_HOLODESK = new AllHolodeskTables();
	public final AllTextTables TABLE_TEXT = new AllTextTables();
	public final AllEsTables TABLE_ES = new AllEsTables();

	public final ReadXmlUtil prop_table_es;
	
	private boolean encryptTablename;
	private final Map<String, Map<String, TextTableBean>> allOtherTables;
	private final Map<Integer, String> encryptOther;
	
	
	public TableInfo() {
		allOtherTables = new ConcurrentHashMap<String, Map<String, TextTableBean>>();
		encryptOther = new ConcurrentHashMap<Integer, String>();
		prop_table_es = new ReadXmlUtil();
	}
	
	public void loadPropertyFile(String path_table_es) {
		prop_table_es.load(path_table_es);
	}
	
	public void setEncrypt(boolean encryptTablename) {
		this.encryptTablename = encryptTablename;
	}
	
	public boolean hasOtherTable() {
		int total = 0;
		for (Entry<String, Map<String, TextTableBean>> entry : allOtherTables.entrySet()) {
			Map<String, TextTableBean> otherTables = entry.getValue();
			total += otherTables.size();
		}
		if (total > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	public void setEncryptTablename(boolean encryptTablename) {
		this.encryptTablename = encryptTablename;
	}
	
	public boolean isEncryptTablename() {
		return this.encryptTablename;
	}
	
	public synchronized void addOtherTables(final String servicename, final Map<String, TextTableBean> otherTables) {
		this.allOtherTables.put(servicename, otherTables);
	}
	
	public synchronized void addEncryptOther(final int tableId, final String tablename) {
		this.encryptOther.put(tableId, tablename);
	}
	
	public Map<String, Map<String, TextTableBean>> getAllOtherTables() {
		return this.allOtherTables;
	}
	
	public Map<Integer, String> getEncryptOther() {
		return this.encryptOther;
	}	
}
