package io.transwarp.common.bean.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

public class MetricBean {

	private String metricName;
	private String unit;
	private Map<Long, String> metricValues;
	
	public MetricBean() {
		super();
		this.metricValues = new HashMap<Long, String>();
	}

	@Override
	public String toString() {
		StringBuffer answer = new StringBuffer();
		answer.append("metricName : " + metricName).append("\n")
				.append("unit : " + unit).append("\n");
		for (Entry<Long, String> entry : metricValues.entrySet()) {
			answer.append(String.format("timestamp : %s, value : %s\n", entry.getKey(), entry.getValue()));
		}
		return answer.toString();
	}
	
	public String getMetricName() {
		return metricName;
	}
	
	public String getUnit() {
		return unit;
	}
	
	public Map<Long, String> getMetricValues() {
		return metricValues;
	}
	
	public void addMetricValues(Long timeStamp, String value) {
		this.metricValues.put(timeStamp, value);
	}
	
	public void setMetricName(Object metricName) {
		if(metricName == null)
			metricName = "";
		this.metricName = metricName.toString();
	}
	
	public void setUnit(Object unit) {
		if(unit == null)
			unit = "";
		String unitString = unit.toString();
		if(unitString.equalsIgnoreCase("percent")) {
			this.unit = "%";
		}else if(unitString.equalsIgnoreCase("mb_per_second")) {
			this.unit = "MB/s";
		}else {
			this.unit = unitString;
		}
	}

	
}
