package io.transwarp.common.bean.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import net.sf.json.JSONObject;

public class NodeBean {
	
	private String id;						//节点ID
	private String hostName;				//节点hostname
	private String ipAddress;				//节点IP
	private String clusterId;				//所属集群编号
	private String clusterName;				//所属集群名称
	private String sshConfigId;				//ssh配置编号
	private String rackId;					//所属机柜编号
	private String rackName;				//所属机柜名称
	private String isManaged;				//是否为manager节点
	private String expectedConfigVersion;	//最近一次配置修改的时间戳
	private String lastHeartbeat;			//最近一次心跳的时间戳
	private String numCores;				//core的数量
	private String totalPhysMemBytes;		//总的物理空间大小
	private String mounts;					//硬盘挂载点
	private String status;					//节点状态
	private String cpu;						//cpu信息
	private String disk;					//磁盘信息
	private String osType;					//操作系统
	private String serverKey;				//机器码
	private String timeZone;                //时区
	
	private Map<String, String> paramByShell;	//通过shell命令查询的系统参数
	private Map<String, MetricBean> metricOneDay;    //节点24小时指标信息
	private Map<String, MetricBean> metricInDetail;  //节点详细指标
	private Map<String, String> portNumber;     //端口连接数
	private String mysqlSynch;
	private String diskFailure;
	
	public NodeBean(final String json) {
		this(JSONObject.fromObject(json));
	}
	
	public NodeBean(final JSONObject json) {
		this.setId(json.get("id"));
		this.setHostName(json.get("hostName"));
		this.setIpAddress(json.get("ipAddress"));
		this.setClusterId(json.get("clusterId"));
		this.setClusterName(json.get("clusterName"));
		this.setSshConfigId(json.get("sshConfigId"));
		this.setRackId(json.get("rackId"));
		this.setRackName(json.get("rackName"));
		this.setIsManaged(json.get("isManaged"));
		this.setExpectedConfigVersion(json.get("expectedConfigVersion"));
		this.setLastHeartbeat(json.get("lastHeartbeat"));
		this.setNumCores(json.get("numCores"));
		this.setTotalPhysMemBytes(json.get("totalPhysMemBytes"));
		this.setMounts(json.get("mounts"));
		this.setStatus(json.get("status"));
		this.setCpu(json.get("cpu"));
		this.setDisk(json.get("disk"));
		this.setOsType(json.get("osType"));
		this.setServerKey(json.get("serverKey"));
		this.setTimeZone("");
		this.setDiskFailure("");
		this.paramByShell = new HashMap<String, String>();
		this.metricOneDay = new HashMap<String, MetricBean>();
		this.metricInDetail = new HashMap<String, MetricBean>();
		this.portNumber = new HashMap<String, String>();
	}
	
	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("nodeId : ").append(this.id)
			.append("\nhostname : ").append(this.hostName)
			.append("\nipAddress : ").append(this.ipAddress)
			.append("\nclusterId : ").append(this.clusterId)
			.append("\nclusterName : ").append(this.clusterName)
			.append("\nsshConfigId : ").append(this.sshConfigId)
			.append("\nrackId : ").append(this.rackId)
			.append("\nrackName : ").append(this.rackName)
			.append("\nisManaged : ").append(this.isManaged)
			.append("\nexpectedConfigVersion : ").append(this.expectedConfigVersion)
			.append("\nlastHeartbeat : ").append(this.lastHeartbeat)
			.append("\nnumCores : ").append(this.numCores)
			.append("\ntotalPhysMemBytes : ").append(this.totalPhysMemBytes)
			.append("\nmounts : ").append(this.mounts)
			.append("\nstatus : ").append(this.status)
			.append("\ncpu : ").append(this.cpu)
			.append("\ndisk : ").append(this.disk)
			.append("\nosType : ").append(this.osType)
			.append("\nserverKey : ").append(this.serverKey)
			.append("\nmysql synchronized : ").append(this.mysqlSynch)
			.append("\nerrorDisk : ").append(this.diskFailure)
			.append("\ntimeZone : ").append(this.timeZone);
		for (Entry<String, String> entry : this.paramByShell.entrySet()) {
			buffer.append("\n").append(entry.getKey()).append(" : ").append(entry.getValue());
		}
		return buffer.toString();
	}
	
	public void addParamByShell(String key, String value) {
		this.paramByShell.put(key, value);
	}
	
	public void addMetricOneDay(final String metricNameCN, final MetricBean metric) {
		this.metricOneDay.put(metricNameCN, metric);
	}
	
	public void addMetricInDetail(final String metricNameCN, final MetricBean metric) {
		this.metricInDetail.put(metricNameCN, metric);
	}
	
	public MetricBean getMetricByName(final String metricNameCN, final Boolean isDetail) {
		if (isDetail) {
			return metricInDetail.get(metricNameCN);
		} else {
			return metricOneDay.get(metricNameCN);
		}
	}
	
	public void addPortNumber(final String port, final String number) {
		this.portNumber.put(port, number);
	}
	
	public String getParamFromShell(final String key) {
		String value = this.paramByShell.get(key);
		if(value == null) {
			value = "";
		}
		return value;
	}
	
	public void setId(Object id) {
		this.id = id == null ? "" : id.toString();
	}

	public void setHostName(Object hostName) {
		this.hostName = hostName == null ? "" : hostName.toString();
	}

	public void setIpAddress(Object ipAddress) {
		this.ipAddress = ipAddress == null ? "" : ipAddress.toString();
	}

	public void setClusterId(Object clusterId) {
		this.clusterId = clusterId == null ? "" : clusterId.toString();
	}

	public void setClusterName(Object clusterName) {
		this.clusterName = clusterName == null ? "" : clusterName.toString();
	}

	public void setSshConfigId(Object sshConfigId) {
		this.sshConfigId = sshConfigId == null ? "" : sshConfigId.toString();
	}

	public void setRackId(Object rackId) {
		this.rackId = rackId == null ? "" : rackId.toString();
	}

	public void setRackName(Object rackName) {
		this.rackName = rackName == null ? "" : rackName.toString();
	}

	public void setIsManaged(Object isManaged) {
		this.isManaged = isManaged == null ? "" : isManaged.toString();
	}

	public void setExpectedConfigVersion(Object expectedConfigVersion) {
		this.expectedConfigVersion = expectedConfigVersion == null ? "" : expectedConfigVersion.toString();
	}

	public void setLastHeartbeat(Object lastHeartbeat) {
		this.lastHeartbeat = lastHeartbeat == null ? "" : lastHeartbeat.toString();
	}

	public void setNumCores(Object numCores) {
		this.numCores = numCores == null ? "" : numCores.toString();
	}

	public void setTotalPhysMemBytes(Object totalPhysMemBytes) {
		this.totalPhysMemBytes = totalPhysMemBytes == null ? "" : totalPhysMemBytes.toString();
	}

	public void setMounts(Object mounts) {
		this.mounts = mounts == null ? "" : mounts.toString();
	}

	public void setStatus(Object status) {
		this.status = status == null ? "" : status.toString();
	}

	public void setCpu(Object cpu) {
		this.cpu = cpu == null ? "" : cpu.toString();
	}

	public void setDisk(Object disk) {
		this.disk = disk == null ? "" : disk.toString();
	}

	public void setOsType(Object osType) {
		this.osType = osType == null ? "" : osType.toString();
	}

	public void setServerKey(Object serverKey) {
		this.serverKey = serverKey == null ? "" : serverKey.toString();
	}
	
	public void setMysqlSynch(Object mysql) {
		this.mysqlSynch = mysql == null ? "" : mysql.toString();
	}
	
	public void setDiskFailure(Object diskFailure) {
		this.diskFailure = diskFailure == null ? "" : diskFailure.toString();
	}
	
	public void setTimeZone(Object timeZone) {
		this.timeZone = timeZone == null ? "" : timeZone.toString();
	}

	public String getId() {
		return id;
	}

	public String getHostName() {
		return hostName;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public String getClusterId() {
		return clusterId;
	}

	public String getClusterName() {
		return clusterName;
	}

	public String getSshConfigId() {
		return sshConfigId;
	}

	public String getRackId() {
		return rackId;
	}

	public String getRackName() {
		return rackName;
	}

	public String getIsManaged() {
		return isManaged;
	}

	public String getExpectedConfigVersion() {
		return expectedConfigVersion;
	}

	public String getLastHeartbeat() {
		return lastHeartbeat;
	}

	public String getNumCores() {
		return numCores;
	}

	public String getTotalPhysMemBytes() {
		return totalPhysMemBytes;
	}

	public String getMounts() {
		return mounts;
	}

	public String getStatus() {
		return status;
	}

	public String getCpu() {
		return cpu;
	}

	public String getDisk() {
		return disk;
	}

	public String getOsType() {
		return osType;
	}

	public String getServerKey() {
		return serverKey;
	}
	
	public String getMysqlSynch() {
		return mysqlSynch;
	}
	
	public String getDiskFailure() {
		return diskFailure;
	}
	
	public String getTimeZone() {
		return timeZone;
	}

	public Map<String, String> getAllParamByShell() {
		return paramByShell;
	}
	
	public Map<String, MetricBean> getMetricOneDay() {
		return metricOneDay;
	}
	
	public Map<String, MetricBean> getMetricInDetail() {
		return metricInDetail;
	}
	
	public Map<String, String> getPortNumber() {
		return portNumber;
	}
}
